/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.stream.DoubleStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class DoubleStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `DoubleStream`s";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.DoubleStreamRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ConcatOneDoubleStreamRecipe(), new ConcatTwoDoubleStreamsRecipe(), new DoubleStreamFilterSortedRecipe(), new DoubleStreamMinRecipe(), new DoubleStreamAllMatchRecipe(), new DoubleStreamTakeWhileRecipe()});
    }

    @NonNullApi
    public static class ConcatOneDoubleStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't unnecessarily call `Streams#concat(DoubleStream...)`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConcatOneDoubleStream {\n    \n    @BeforeTemplate\n    DoubleStream before(DoubleStream stream) {\n        return Streams.concat(stream);\n    }\n    \n    @AfterTemplate\n    @CanIgnoreReturnValue\n    DoubleStream after(DoubleStream stream) {\n        return stream;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", stream -> Streams.concat((DoubleStream[])new DoubleStream[]{stream})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", stream -> stream).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ConcatTwoDoubleStreamsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `DoubleStream#concat(DoubleStream, DoubleStream)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConcatTwoDoubleStreams {\n    \n    @BeforeTemplate\n    DoubleStream before(DoubleStream s1, DoubleStream s2) {\n        return Streams.concat(s1, s2);\n    }\n    \n    @AfterTemplate\n    DoubleStream after(DoubleStream s1, DoubleStream s2) {\n        return DoubleStream.concat(s1, s2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s1, s2) -> Streams.concat((DoubleStream[])new DoubleStream[]{s1, s2})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s1, s2) -> DoubleStream.concat(s1, s2)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DoubleStreamFilterSortedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Apply `DoubleStream#filter(DoublePredicate)` before `DoubleStream#sorted()` to reduce the number of elements to sort";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleStreamFilterSorted {\n    \n    @BeforeTemplate\n    DoubleStream before(DoubleStream stream, DoublePredicate predicate) {\n        return stream.sorted().filter(predicate);\n    }\n    \n    @AfterTemplate\n    DoubleStream after(DoubleStream stream, DoublePredicate predicate) {\n        return stream.filter(predicate).sorted();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.sorted().filter((DoublePredicate)predicate)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.filter((DoublePredicate)predicate).sorted()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.DoublePredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.DoubleStream filter(..)"), new UsesMethod("java.util.stream.DoubleStream sorted(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DoubleStreamMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamMin`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleStreamMin {\n    \n    @BeforeTemplate\n    OptionalDouble before(DoubleStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalDouble after(DoubleStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", stream -> stream.sorted().findFirst()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", stream -> stream.min()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalDouble", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.DoubleStream findFirst(..)"), new UsesMethod("java.util.stream.DoubleStream sorted(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DoubleStreamAllMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamAllMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(DoubleStream stream, DoublePredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(DoubleStream stream, DoublePredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.noneMatch(predicate.negate())).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.allMatch((DoublePredicate)predicate)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.DoublePredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.DoubleStream noneMatch(..)"), new UsesMethod("java.util.function.DoublePredicate negate(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DoubleStreamTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `DoubleStreamRules.DoubleStreamTakeWhile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleStreamTakeWhile {\n    \n    @BeforeTemplate\n    DoubleStream before(DoubleStream stream, DoublePredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    DoubleStream after(DoubleStream stream, DoublePredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.takeWhile((DoublePredicate)predicate).filter((DoublePredicate)predicate)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.takeWhile((DoublePredicate)predicate)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.DoublePredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.DoubleStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.DoubleStream filter(..)"), new UsesMethod("java.util.stream.DoubleStream takeWhile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

