/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class BigDecimalRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `BigDecimal`s";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.BigDecimalRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new BigDecimalValueOfRecipe()});
    }

    @NonNullApi
    public static class BigDecimalValueOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `BigDecimal#valueOf(double)` over the associated constructor";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BigDecimalValueOf {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S2111\")\n    BigDecimal before(double value) {\n        return new BigDecimal(value);\n    }\n    \n    @AfterTemplate\n    BigDecimal after(double value) {\n        return BigDecimal.valueOf(value);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", value -> new BigDecimal((double)value)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", value -> BigDecimal.valueOf(value)).build();

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigDecimal", Boolean.valueOf(true)), new UsesMethod("java.math.BigDecimal <constructor>(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

