/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssortedRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Assorted Refaster rules that do not (yet) belong in one of the other classes with more topical Refaster rules";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssortedRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new CheckIndexRecipe(), new LogicalImplicationRecipe()});
    }

    @NonNullApi
    public static class CheckIndexRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Objects#checkIndex(int, int)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CheckIndex {\n    \n    @BeforeTemplate\n    int before(int index, int size) {\n        return checkElementIndex(index, size);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    int after(int index, int size) {\n        return checkIndex(index, size);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (index, size) -> com.google.common.base.Preconditions.checkElementIndex((int)index, (int)size)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (index, size) -> Objects.checkIndex(index, size)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions.checkElementIndex");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.base.Preconditions checkElementIndex(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LogicalImplicationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't unnecessarily repeat boolean expressions";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LogicalImplication {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S2589\")\n    boolean before(boolean firstTest, boolean secondTest) {\n        return firstTest || (!firstTest && secondTest);\n    }\n    \n    @AfterTemplate\n    boolean after(boolean firstTest, boolean secondTest) {\n        return firstTest || secondTest;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (firstTest, secondTest) -> firstTest != false || firstTest == false && secondTest != false).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (firstTest, secondTest) -> firstTest != false || secondTest != false).build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }
}

