/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJStringRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJStringRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJStringRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractStringAssertStringIsEmptyRecipe(), new AssertThatStringIsEmptyRecipe(), new AbstractStringAssertStringIsNotEmptyRecipe(), new AssertThatStringIsNotEmptyRecipe(), new AssertThatMatchesRecipe(), new AssertThatDoesNotMatchRecipe(), new AssertThatPathContentRecipe(), new AssertThatPathContentUtf8Recipe()});
    }

    @NonNullApi
    public static class AbstractStringAssertStringIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AbstractStringAssertStringIsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractStringAssertStringIsEmpty {\n    \n    @BeforeTemplate\n    void before(AbstractStringAssert<?> stringAssert) {\n        stringAssert.isEqualTo(\"\");\n    }\n    \n    @AfterTemplate\n    void after(AbstractStringAssert<?> stringAssert) {\n        stringAssert.isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", stringAssert -> stringAssert.isEqualTo("")).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", stringAssert -> stringAssert.isEmpty()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractStringAssert isEqualTo(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatStringIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatStringIsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringIsEmpty {\n    \n    @BeforeTemplate\n    void before(String string) {\n        assertThat(string.isEmpty()).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(String string) {\n        assertThat(string).isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", string -> Assertions.assertThat((boolean)string.isEmpty()).isTrue()).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", string -> Assertions.assertThat((String)string).isEmpty()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)"), new UsesMethod("java.lang.String isEmpty(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractStringAssertStringIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AbstractStringAssertStringIsNotEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractStringAssertStringIsNotEmpty {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(AbstractStringAssert<?> stringAssert) {\n        return stringAssert.isNotEqualTo(\"\");\n    }\n    \n    @AfterTemplate\n    AbstractStringAssert<?> after(AbstractStringAssert<?> stringAssert) {\n        return stringAssert.isNotEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", stringAssert -> stringAssert.isNotEqualTo((Object)"")).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", stringAssert -> stringAssert.isNotEmpty()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractAssert isNotEqualTo(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatStringIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatStringIsNotEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringIsNotEmpty {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(String string) {\n        return assertThat(string.isEmpty()).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractAssert<?, ?> after(String string) {\n        return assertThat(string).isNotEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", string -> Assertions.assertThat((boolean)string.isEmpty()).isFalse()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", string -> Assertions.assertThat((String)string).isNotEmpty()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)"), new UsesMethod("java.lang.String isEmpty(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatMatchesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatMatches`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMatches {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(String string, String regex) {\n        return assertThat(string.matches(regex)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractAssert<?, ?> after(String string, String regex) {\n        return assertThat(string).matches(regex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (string, regex) -> Assertions.assertThat((boolean)string.matches((String)regex)).isTrue()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (string, regex) -> Assertions.assertThat((String)string).matches((CharSequence)regex)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)"), new UsesMethod("java.lang.String matches(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatDoesNotMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatDoesNotMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoesNotMatch {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(String string, String regex) {\n        return assertThat(string.matches(regex)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractAssert<?, ?> after(String string, String regex) {\n        return assertThat(string).doesNotMatch(regex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (string, regex) -> Assertions.assertThat((boolean)string.matches((String)regex)).isFalse()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (string, regex) -> Assertions.assertThat((String)string).doesNotMatch((CharSequence)regex)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)"), new UsesMethod("java.lang.String matches(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatPathContentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatPathContent`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPathContent {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(Path path, Charset charset) throws IOException {\n        return assertThat(Files.readString(path, charset));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(Path path, Charset charset) {\n        return assertThat(path).content(charset);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (path, charset) -> Assertions.assertThat((String)Files.readString(path, charset))).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (path, charset) -> Assertions.assertThat((Path)path).content(charset)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.file.Files");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.charset.Charset", Boolean.valueOf(true)), new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)"), new UsesMethod("java.nio.file.Files readString(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatPathContentUtf8Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatPathContentUtf8`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPathContentUtf8 {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(Path path) throws IOException {\n        return assertThat(Files.readString(path));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(Path path) {\n        return assertThat(path).content(UTF_8);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", path -> Assertions.assertThat((String)Files.readString(path))).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", path -> Assertions.assertThat((Path)path).content(StandardCharsets.UTF_8)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.file.Files");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)"), new UsesMethod("java.nio.file.Files readString(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

