/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJNumberRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJNumberRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJNumberRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatIsEvenRecipe()});
    }

    @NonNullApi
    public static class AssertThatIsEvenRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `AbstractLongAssert#isEven()` (and similar methods for other `NumberAssert` subtypes) over alternatives with less informative error messages";
        }

        public String getDescription() {
            return "<p>Note that `org.assertj.core.api.AbstractCharacterAssert` does not implement `NumberAssert` and does not provide an `isEven` test.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", number -> Assertions.assertThat((int)(number % 2)).isEqualTo(0)).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", number -> Assertions.assertThat((long)(number % 2L)).isEqualTo(0L)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", number -> Assertions.assertThat((Long)number).isEven()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.Assertions assertThat(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isEqualTo(..)")})})}), (TreeVisitor)javaVisitor);
        }
    }
}

