/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;

final class PrimitiveRules {
    private PrimitiveRules() {
    }

    static final class DoubleIsFinite {
        DoubleIsFinite() {
        }

        boolean before(double d) {
            return Doubles.isFinite((double)d);
        }

        boolean after(double d) {
            return Double.isFinite(d);
        }
    }

    static final class FloatIsFinite {
        FloatIsFinite() {
        }

        boolean before(float f) {
            return Floats.isFinite((float)f);
        }

        boolean after(float f) {
            return Float.isFinite(f);
        }
    }

    static final class DoubleBytes {
        DoubleBytes() {
        }

        int before() {
            return 8;
        }

        int after() {
            return 8;
        }
    }

    static final class FloatBytes {
        FloatBytes() {
        }

        int before() {
            return 4;
        }

        int after() {
            return 4;
        }
    }

    static final class LongBytes {
        LongBytes() {
        }

        int before() {
            return 8;
        }

        int after() {
            return 8;
        }
    }

    static final class IntegerBytes {
        IntegerBytes() {
        }

        int before() {
            return 4;
        }

        int after() {
            return 4;
        }
    }

    static final class ShortBytes {
        ShortBytes() {
        }

        int before() {
            return 2;
        }

        int after() {
            return 2;
        }
    }

    static final class CharacterBytes {
        CharacterBytes() {
        }

        int before() {
            return 2;
        }

        int after() {
            return 2;
        }
    }

    static final class DoubleCompare {
        DoubleCompare() {
        }

        int before(double a, double b) {
            return Doubles.compare((double)a, (double)b);
        }

        int after(double a, double b) {
            return Double.compare(a, b);
        }
    }

    static final class FloatCompare {
        FloatCompare() {
        }

        int before(float a, float b) {
            return Floats.compare((float)a, (float)b);
        }

        int after(float a, float b) {
            return Float.compare(a, b);
        }
    }

    static final class LongCompare {
        LongCompare() {
        }

        int before(long a, long b) {
            return Longs.compare((long)a, (long)b);
        }

        int after(long a, long b) {
            return Long.compare(a, b);
        }
    }

    static final class IntegerCompare {
        IntegerCompare() {
        }

        int before(int a, int b) {
            return Ints.compare((int)a, (int)b);
        }

        int after(int a, int b) {
            return Integer.compare(a, b);
        }
    }

    static final class ShortCompare {
        ShortCompare() {
        }

        int before(short a, short b) {
            return Shorts.compare((short)a, (short)b);
        }

        int after(short a, short b) {
            return Short.compare(a, b);
        }
    }

    static final class CharacterCompare {
        CharacterCompare() {
        }

        int before(char a, char b) {
            return Chars.compare((char)a, (char)b);
        }

        int after(char a, char b) {
            return Character.compare(a, b);
        }
    }

    static final class BooleanCompare {
        BooleanCompare() {
        }

        int before(boolean a, boolean b) {
            return Booleans.compare((boolean)a, (boolean)b);
        }

        int after(boolean a, boolean b) {
            return Boolean.compare(a, b);
        }
    }

    static final class DoubleHashCode {
        DoubleHashCode() {
        }

        int before(double d) {
            return Doubles.hashCode((double)d);
        }

        int after(double d) {
            return Double.hashCode(d);
        }
    }

    static final class FloatHashCode {
        FloatHashCode() {
        }

        int before(float f) {
            return Floats.hashCode((float)f);
        }

        int after(float f) {
            return Float.hashCode(f);
        }
    }

    static final class LongHashCode {
        LongHashCode() {
        }

        int before(long l) {
            return Longs.hashCode((long)l);
        }

        int after(long l) {
            return Long.hashCode(l);
        }
    }

    static final class IntegerHashCode {
        IntegerHashCode() {
        }

        int before(int i) {
            return Ints.hashCode((int)i);
        }

        int after(int i) {
            return Integer.hashCode(i);
        }
    }

    static final class ShortHashCode {
        ShortHashCode() {
        }

        int before(short s) {
            return Shorts.hashCode((short)s);
        }

        int after(short s) {
            return Short.hashCode(s);
        }
    }

    static final class CharacterHashCode {
        CharacterHashCode() {
        }

        int before(char c) {
            return Chars.hashCode((char)c);
        }

        int after(char c) {
            return Character.hashCode(c);
        }
    }

    static final class ByteHashCode {
        ByteHashCode() {
        }

        int before(byte b) {
            return Bytes.hashCode((byte)b);
        }

        int after(byte b) {
            return Byte.hashCode(b);
        }
    }

    static final class BooleanHashCode {
        BooleanHashCode() {
        }

        int before(boolean b) {
            return Booleans.hashCode((boolean)b);
        }

        int after(boolean b) {
            return Boolean.hashCode(b);
        }
    }

    static final class LongToIntExact {
        LongToIntExact() {
        }

        int before(long l) {
            return Ints.checkedCast((long)l);
        }

        int after(long l) {
            return Math.toIntExact(l);
        }
    }

    static final class GreaterThanOrEqualTo {
        GreaterThanOrEqualTo() {
        }

        boolean before(double a, double b) {
            return !(a < b);
        }

        boolean after(double a, double b) {
            return a >= b;
        }
    }

    static final class GreaterThan {
        GreaterThan() {
        }

        boolean before(double a, double b) {
            return !(a <= b);
        }

        boolean after(double a, double b) {
            return a > b;
        }
    }

    static final class LessThanOrEqualTo {
        LessThanOrEqualTo() {
        }

        boolean before(double a, double b) {
            return !(a > b);
        }

        boolean after(double a, double b) {
            return a <= b;
        }
    }

    static final class LessThan {
        LessThan() {
        }

        boolean before(double a, double b) {
            return !(a >= b);
        }

        boolean after(double a, double b) {
            return a < b;
        }
    }
}

