/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import tech.picnic.errorprone.bugpatterns.util.MoreTypePredicates;
import tech.picnic.errorprone.bugpatterns.util.MoreTypes;

@BugPattern(summary="Avoid `Publisher`s that emit other `Publishers`s; the resultant code is hard to reason about", link="https://error-prone.picnic.tech/bugpatterns/NestedPublishers", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class NestedPublishers
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Supplier<Type> PUBLISHER = MoreTypes.type("org.reactivestreams.Publisher");
    private static final Matcher<ExpressionTree> IS_NON_GROUPED_PUBLISHER_OF_PUBLISHERS = Matchers.typePredicateMatcher((TypePredicate)TypePredicates.allOf((TypePredicate[])new TypePredicate[]{MoreTypePredicates.isSubTypeOf(MoreTypes.generic(PUBLISHER, MoreTypes.subOf(MoreTypes.raw(PUBLISHER)))), TypePredicates.not((TypePredicate)MoreTypePredicates.hasTypeParameter(0, MoreTypePredicates.isSubTypeOf(MoreTypes.raw(MoreTypes.type("reactor.core.publisher.GroupedFlux")))))}));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return IS_NON_GROUPED_PUBLISHER_OF_PUBLISHERS.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

