/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

final class TimeRules {
    private TimeRules() {
    }

    static final class ZeroPeriod {
        ZeroPeriod() {
        }

        Period before() {
            return (Period)Refaster.anyOf((Object[])new Period[]{Period.ofDays(0), Period.ofWeeks(0), Period.ofMonths(0), Period.ofYears(0), Period.of(0, 0, 0)});
        }

        Period after() {
            return Period.ZERO;
        }
    }

    static final class DurationIsZero {
        DurationIsZero() {
        }

        boolean before(Duration duration) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{duration.equals(Duration.ZERO), Duration.ZERO.equals(duration)});
        }

        boolean after(Duration duration) {
            return duration.isZero();
        }
    }

    static final class DurationBetweenOffsetDateTimes {
        DurationBetweenOffsetDateTimes() {
        }

        Duration before(OffsetDateTime a, OffsetDateTime b) {
            return (Duration)Refaster.anyOf((Object[])new Duration[]{Duration.between(a.toInstant(), b.toInstant()), Duration.ofSeconds(b.toEpochSecond() - a.toEpochSecond())});
        }

        Duration after(OffsetDateTime a, OffsetDateTime b) {
            return Duration.between(a, b);
        }
    }

    static final class DurationBetweenInstants {
        DurationBetweenInstants() {
        }

        Duration before(Instant a, Instant b) {
            return Duration.ofMillis(b.toEpochMilli() - a.toEpochMilli());
        }

        Duration after(Instant a, Instant b) {
            return Duration.between(a, b);
        }
    }

    static final class DurationOfSeconds {
        DurationOfSeconds() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.SECONDS);
        }

        Duration after(long amount) {
            return Duration.ofSeconds(amount);
        }
    }

    static final class DurationOfNanos {
        DurationOfNanos() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.NANOS);
        }

        Duration after(long amount) {
            return Duration.ofNanos(amount);
        }
    }

    static final class DurationOfMinutes {
        DurationOfMinutes() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.MINUTES);
        }

        Duration after(long amount) {
            return Duration.ofMinutes(amount);
        }
    }

    static final class DurationOfMillis {
        DurationOfMillis() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.MILLIS);
        }

        Duration after(long amount) {
            return Duration.ofMillis(amount);
        }
    }

    static final class DurationOfHours {
        DurationOfHours() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.HOURS);
        }

        Duration after(long amount) {
            return Duration.ofHours(amount);
        }
    }

    static final class DurationOfDays {
        DurationOfDays() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.DAYS);
        }

        Duration after(long amount) {
            return Duration.ofDays(amount);
        }
    }

    static final class ZeroDuration {
        ZeroDuration() {
        }

        Duration before(TemporalUnit temporalUnit) {
            return (Duration)Refaster.anyOf((Object[])new Duration[]{Duration.ofNanos(0L), Duration.ofMillis(0L), Duration.ofSeconds(0L), Duration.ofSeconds(0L, 0L), Duration.ofMinutes(0L), Duration.ofHours(0L), Duration.ofDays(0L), Duration.of(0L, temporalUnit)});
        }

        Duration after() {
            return Duration.ZERO;
        }
    }

    static final class OffsetDateTimeIsAfter {
        OffsetDateTimeIsAfter() {
        }

        boolean before(OffsetDateTime a, OffsetDateTime b) {
            return a.compareTo(b) > 0;
        }

        boolean after(OffsetDateTime a, OffsetDateTime b) {
            return a.isAfter(b);
        }
    }

    static final class OffsetDateTimeIsBefore {
        OffsetDateTimeIsBefore() {
        }

        boolean before(OffsetDateTime a, OffsetDateTime b) {
            return a.compareTo(b) < 0;
        }

        boolean after(OffsetDateTime a, OffsetDateTime b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoZonedDateTimeIsAfter {
        ChronoZonedDateTimeIsAfter() {
        }

        boolean before(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoZonedDateTimeIsBefore {
        ChronoZonedDateTimeIsBefore() {
        }

        boolean before(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoLocalDateTimeIsAfter {
        ChronoLocalDateTimeIsAfter() {
        }

        boolean before(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoLocalDateTimeIsBefore {
        ChronoLocalDateTimeIsBefore() {
        }

        boolean before(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoLocalDateIsAfter {
        ChronoLocalDateIsAfter() {
        }

        boolean before(ChronoLocalDate a, ChronoLocalDate b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoLocalDate a, ChronoLocalDate b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoLocalDateIsBefore {
        ChronoLocalDateIsBefore() {
        }

        boolean before(ChronoLocalDate a, ChronoLocalDate b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoLocalDate a, ChronoLocalDate b) {
            return a.isBefore(b);
        }
    }

    static final class LocalDateAtStartOfDay {
        LocalDateAtStartOfDay() {
        }

        LocalDateTime before(LocalDate localDate) {
            return localDate.atTime(LocalTime.MIN);
        }

        LocalDateTime after(LocalDate localDate) {
            return localDate.atStartOfDay();
        }
    }

    static final class LocalTimeMin {
        LocalTimeMin() {
        }

        LocalTime before() {
            return (LocalTime)Refaster.anyOf((Object[])new LocalTime[]{LocalTime.MIDNIGHT, LocalTime.of(0, 0), LocalTime.of(0, 0, 0), LocalTime.of(0, 0, 0, 0), LocalTime.ofNanoOfDay(0L), LocalTime.ofSecondOfDay(0L)});
        }

        LocalTime after() {
            return LocalTime.MIN;
        }
    }

    static final class InstantIsAfter {
        InstantIsAfter() {
        }

        boolean before(Instant a, Instant b) {
            return a.compareTo(b) > 0;
        }

        boolean after(Instant a, Instant b) {
            return a.isAfter(b);
        }
    }

    static final class InstantIsBefore {
        InstantIsBefore() {
        }

        boolean before(Instant a, Instant b) {
            return a.compareTo(b) < 0;
        }

        boolean after(Instant a, Instant b) {
            return a.isBefore(b);
        }
    }

    static final class EpochInstant {
        EpochInstant() {
        }

        Instant before() {
            return (Instant)Refaster.anyOf((Object[])new Instant[]{Instant.ofEpochMilli(0L), Instant.ofEpochSecond(0L), Instant.ofEpochSecond(0L, 0L)});
        }

        Instant after() {
            return Instant.EPOCH;
        }
    }

    static final class UtcClock {
        UtcClock() {
        }

        Clock before() {
            return Clock.system(ZoneOffset.UTC);
        }

        Clock after() {
            return Clock.systemUTC();
        }
    }

    static final class InstantAtZone {
        InstantAtZone() {
        }

        ZonedDateTime before(Instant instant, ZoneId zoneId) {
            return ZonedDateTime.ofInstant(instant, zoneId);
        }

        ZonedDateTime after(Instant instant, ZoneId zoneId) {
            return instant.atZone(zoneId);
        }
    }

    static final class OffsetTimeOfInstant {
        OffsetTimeOfInstant() {
        }

        OffsetTime before(Instant instant, ZoneId zoneId) {
            return OffsetDateTime.ofInstant(instant, zoneId).toOffsetTime();
        }

        OffsetTime before(Instant instant, ZoneOffset zoneId) {
            return instant.atOffset(zoneId).toOffsetTime();
        }

        OffsetTime after(Instant instant, ZoneId zoneId) {
            return OffsetTime.ofInstant(instant, zoneId);
        }
    }

    static final class InstantAtOffset {
        InstantAtOffset() {
        }

        OffsetDateTime before(Instant instant, ZoneOffset zoneOffset) {
            return OffsetDateTime.ofInstant(instant, zoneOffset);
        }

        OffsetDateTime after(Instant instant, ZoneOffset zoneOffset) {
            return instant.atOffset(zoneOffset);
        }
    }

    static final class OffsetDateTimeOfInstant {
        OffsetDateTimeOfInstant() {
        }

        OffsetDateTime before(Instant instant, ZoneId zoneId) {
            return instant.atZone(zoneId).toOffsetDateTime();
        }

        OffsetDateTime after(Instant instant, ZoneId zoneId) {
            return OffsetDateTime.ofInstant(instant, zoneId);
        }
    }

    static final class LocalTimeOfInstant {
        LocalTimeOfInstant() {
        }

        LocalTime before(Instant instant, ZoneId zoneId) {
            return (LocalTime)Refaster.anyOf((Object[])new LocalTime[]{instant.atZone(zoneId).toLocalTime(), LocalDateTime.ofInstant(instant, zoneId).toLocalTime(), OffsetDateTime.ofInstant(instant, zoneId).toLocalTime(), OffsetTime.ofInstant(instant, zoneId).toLocalTime()});
        }

        LocalTime before(Instant instant, ZoneOffset zoneId) {
            return instant.atOffset(zoneId).toLocalTime();
        }

        LocalTime after(Instant instant, ZoneId zoneId) {
            return LocalTime.ofInstant(instant, zoneId);
        }
    }

    static final class LocalDateTimeOfInstant {
        LocalDateTimeOfInstant() {
        }

        LocalDateTime before(Instant instant, ZoneId zoneId) {
            return (LocalDateTime)Refaster.anyOf((Object[])new LocalDateTime[]{instant.atZone(zoneId).toLocalDateTime(), OffsetDateTime.ofInstant(instant, zoneId).toLocalDateTime()});
        }

        LocalDateTime before(Instant instant, ZoneOffset zoneId) {
            return instant.atOffset(zoneId).toLocalDateTime();
        }

        LocalDateTime after(Instant instant, ZoneId zoneId) {
            return LocalDateTime.ofInstant(instant, zoneId);
        }
    }

    static final class LocalDateOfInstant {
        LocalDateOfInstant() {
        }

        LocalDate before(Instant instant, ZoneId zoneId) {
            return (LocalDate)Refaster.anyOf((Object[])new LocalDate[]{instant.atZone(zoneId).toLocalDate(), LocalDateTime.ofInstant(instant, zoneId).toLocalDate(), OffsetDateTime.ofInstant(instant, zoneId).toLocalDate()});
        }

        LocalDate before(Instant instant, ZoneOffset zoneId) {
            return instant.atOffset(zoneId).toLocalDate();
        }

        LocalDate after(Instant instant, ZoneId zoneId) {
            return LocalDate.ofInstant(instant, zoneId);
        }
    }

    static final class UtcConstant {
        UtcConstant() {
        }

        ZoneId before() {
            return (ZoneId)Refaster.anyOf((Object[])new ZoneId[]{ZoneId.of("GMT"), ZoneId.of("UTC"), ZoneId.of("+0"), ZoneId.of("-0"), ZoneOffset.UTC.normalized(), ZoneId.from(ZoneOffset.UTC)});
        }

        ZoneOffset after() {
            return ZoneOffset.UTC;
        }
    }

    static final class ClockInstant {
        ClockInstant() {
        }

        Instant before(Clock clock) {
            return Instant.now(clock);
        }

        Instant after(Clock clock) {
            return clock.instant();
        }
    }
}

