/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class StreamRules {
    private StreamRules() {
    }

    static final class StreamTakeWhile<T> {
        StreamTakeWhile() {
        }

        Stream<T> before(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.takeWhile(predicate).filter(predicate);
        }

        Stream<T> after(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.takeWhile(predicate);
        }
    }

    static final class StreamsConcat<T> {
        StreamsConcat() {
        }

        Stream<T> before(Stream<T> stream) {
            return Stream.of((Stream[])Refaster.asVarargs(stream)).flatMap((Function)Refaster.anyOf((Object[])new Function[]{Function.identity(), s -> s}));
        }

        Stream<T> after(Stream<T> stream) {
            return Streams.concat((Stream[])((Stream[])Refaster.asVarargs(stream)));
        }
    }

    static final class StreamFlatMapCollect<T, U, R> {
        StreamFlatMapCollect() {
        }

        R before(Stream<T> stream, Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, ?, R> collector) {
            return stream.collect(Collectors.flatMapping(mapper, collector));
        }

        R after(Stream<T> stream, Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, ?, R> collector) {
            return stream.flatMap(mapper).collect(collector);
        }
    }

    static final class StreamMapCollect<T, U, R> {
        StreamMapCollect() {
        }

        R before(Stream<T> stream, Function<? super T, ? extends U> mapper, Collector<? super U, ?, R> collector) {
            return stream.collect(Collectors.mapping(mapper, collector));
        }

        R after(Stream<T> stream, Function<? super T, ? extends U> mapper, Collector<? super U, ?, R> collector) {
            return stream.map(mapper).collect(collector);
        }
    }

    static final class StreamFilterCollect<T, R> {
        StreamFilterCollect() {
        }

        R before(Stream<T> stream, Predicate<? super T> predicate, Collector<? super T, ?, R> collector) {
            return stream.collect(Collectors.filtering(predicate, collector));
        }

        R after(Stream<T> stream, Predicate<? super T> predicate, Collector<? super T, ?, R> collector) {
            return stream.filter(predicate).collect(collector);
        }
    }

    static final class StreamReduceWithIdentity<T> {
        StreamReduceWithIdentity() {
        }

        T before(Stream<T> stream, T identity, BinaryOperator<T> accumulator) {
            return stream.collect(Collectors.reducing(identity, accumulator));
        }

        T after(Stream<T> stream, T identity, BinaryOperator<T> accumulator) {
            return stream.reduce(identity, accumulator);
        }
    }

    static final class StreamReduce<T> {
        StreamReduce() {
        }

        Optional<T> before(Stream<T> stream, BinaryOperator<T> accumulator) {
            return stream.collect(Collectors.reducing(accumulator));
        }

        Optional<T> after(Stream<T> stream, BinaryOperator<T> accumulator) {
            return stream.reduce(accumulator);
        }
    }

    static final class StreamCount<T> {
        StreamCount() {
        }

        long before(Stream<T> stream) {
            return stream.collect(Collectors.counting());
        }

        long after(Stream<T> stream) {
            return stream.count();
        }
    }

    static final class StreamMapToLongSummaryStatistics<T> {
        StreamMapToLongSummaryStatistics() {
        }

        LongSummaryStatistics before(Stream<T> stream, ToLongFunction<T> mapper) {
            return stream.collect(Collectors.summarizingLong(mapper));
        }

        LongSummaryStatistics after(Stream<T> stream, ToLongFunction<T> mapper) {
            return stream.mapToLong(mapper).summaryStatistics();
        }
    }

    static final class StreamMapToDoubleSummaryStatistics<T> {
        StreamMapToDoubleSummaryStatistics() {
        }

        DoubleSummaryStatistics before(Stream<T> stream, ToDoubleFunction<T> mapper) {
            return stream.collect(Collectors.summarizingDouble(mapper));
        }

        DoubleSummaryStatistics after(Stream<T> stream, ToDoubleFunction<T> mapper) {
            return stream.mapToDouble(mapper).summaryStatistics();
        }
    }

    static final class StreamMapToIntSummaryStatistics<T> {
        StreamMapToIntSummaryStatistics() {
        }

        IntSummaryStatistics before(Stream<T> stream, ToIntFunction<T> mapper) {
            return stream.collect(Collectors.summarizingInt(mapper));
        }

        IntSummaryStatistics after(Stream<T> stream, ToIntFunction<T> mapper) {
            return stream.mapToInt(mapper).summaryStatistics();
        }
    }

    static final class StreamMapToLongSum<T> {
        StreamMapToLongSum() {
        }

        long before(Stream<T> stream, ToLongFunction<T> mapper) {
            return stream.collect(Collectors.summingLong(mapper));
        }

        long before2(Stream<T> stream, Function<? super T, Long> mapper) {
            return stream.map(mapper).reduce(0L, Long::sum);
        }

        long after(Stream<T> stream, ToLongFunction<T> mapper) {
            return stream.mapToLong(mapper).sum();
        }
    }

    static final class StreamMapToDoubleSum<T> {
        StreamMapToDoubleSum() {
        }

        double before(Stream<T> stream, ToDoubleFunction<T> mapper) {
            return stream.collect(Collectors.summingDouble(mapper));
        }

        double before2(Stream<T> stream, Function<? super T, Double> mapper) {
            return stream.map(mapper).reduce(0.0, Double::sum);
        }

        double after(Stream<T> stream, ToDoubleFunction<T> mapper) {
            return stream.mapToDouble(mapper).sum();
        }
    }

    static final class StreamMapToIntSum<T> {
        StreamMapToIntSum() {
        }

        long before(Stream<T> stream, ToIntFunction<T> mapper) {
            return stream.collect(Collectors.summingInt(mapper)).intValue();
        }

        int before2(Stream<T> stream, Function<? super T, Integer> mapper) {
            return stream.map(mapper).reduce(0, Integer::sum);
        }

        int after(Stream<T> stream, ToIntFunction<T> mapper) {
            return stream.mapToInt(mapper).sum();
        }
    }

    static abstract class StreamAllMatch2<T> {
        StreamAllMatch2() {
        }

        abstract boolean test(T var1);

        boolean before(Stream<T> stream) {
            return stream.noneMatch(e -> !this.test(e));
        }

        boolean after(Stream<T> stream) {
            return stream.allMatch(e -> this.test(e));
        }
    }

    static final class StreamAllMatch<T> {
        StreamAllMatch() {
        }

        boolean before(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.noneMatch((Predicate)Refaster.anyOf((Object[])new Predicate[]{Predicate.not(predicate), predicate.negate()}));
        }

        boolean before2(Stream<T> stream, Function<? super T, Boolean> predicate) {
            return stream.map(predicate).allMatch((Predicate)Refaster.anyOf((Object[])new Predicate[]{Boolean::booleanValue, b -> b}));
        }

        boolean after(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.allMatch(predicate);
        }
    }

    static final class StreamAnyMatch<T> {
        StreamAnyMatch() {
        }

        boolean before(Stream<T> stream, Predicate<? super T> predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.noneMatch(predicate), stream.filter(predicate).findAny().isPresent()});
        }

        boolean before2(Stream<T> stream, Function<? super T, Boolean> predicate) {
            return stream.map(predicate).anyMatch((Predicate)Refaster.anyOf((Object[])new Predicate[]{Boolean::booleanValue, b -> b}));
        }

        boolean after(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.anyMatch(predicate);
        }
    }

    static abstract class StreamNoneMatch2<T> {
        StreamNoneMatch2() {
        }

        abstract boolean test(T var1);

        boolean before(Stream<T> stream) {
            return stream.allMatch(e -> !this.test(e));
        }

        boolean after(Stream<T> stream) {
            return stream.noneMatch(e -> this.test(e));
        }
    }

    static final class StreamNoneMatch<T> {
        StreamNoneMatch() {
        }

        boolean before(Stream<T> stream, Predicate<? super T> predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.anyMatch(predicate), stream.allMatch((Predicate)Refaster.anyOf((Object[])new Predicate[]{Predicate.not(predicate), predicate.negate()})), stream.filter(predicate).findAny().isEmpty()});
        }

        boolean before2(Stream<T> stream, Function<? super T, Boolean> predicate) {
            return stream.map(predicate).noneMatch((Predicate)Refaster.anyOf((Object[])new Predicate[]{Boolean::booleanValue, b -> b}));
        }

        boolean after(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.noneMatch(predicate);
        }
    }

    static final class StreamMaxNaturalOrder<T extends Comparable<? super T>> {
        StreamMaxNaturalOrder() {
        }

        Optional<T> before(Stream<T> stream) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{stream.min(Comparator.reverseOrder()), Streams.findLast(stream.sorted())});
        }

        Optional<T> after(Stream<T> stream) {
            return stream.max(Comparator.naturalOrder());
        }
    }

    static final class StreamMax<T> {
        StreamMax() {
        }

        Optional<T> before(Stream<T> stream, Comparator<? super T> comparator) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{stream.min(comparator.reversed()), Streams.findLast(stream.sorted(comparator)), stream.collect(Collectors.maxBy(comparator))});
        }

        Optional<T> after(Stream<T> stream, Comparator<? super T> comparator) {
            return stream.max(comparator);
        }
    }

    static final class StreamMinNaturalOrder<T extends Comparable<? super T>> {
        StreamMinNaturalOrder() {
        }

        Optional<T> before(Stream<T> stream) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{stream.max(Comparator.reverseOrder()), stream.sorted().findFirst()});
        }

        Optional<T> after(Stream<T> stream) {
            return stream.min(Comparator.naturalOrder());
        }
    }

    static final class StreamMin<T> {
        StreamMin() {
        }

        Optional<T> before(Stream<T> stream, Comparator<? super T> comparator) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{stream.max(comparator.reversed()), stream.sorted(comparator).findFirst(), stream.collect(Collectors.minBy(comparator))});
        }

        Optional<T> after(Stream<T> stream, Comparator<? super T> comparator) {
            return stream.min(comparator);
        }
    }

    static final class StreamIsNotEmpty<T> {
        StreamIsNotEmpty() {
        }

        boolean before(Stream<T> stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() != 0L, stream.count() > 0L, stream.count() >= 1L, stream.findFirst().isPresent()});
        }

        boolean after(Stream<T> stream) {
            return stream.findAny().isPresent();
        }
    }

    static final class StreamIsEmpty<T> {
        StreamIsEmpty() {
        }

        boolean before(Stream<T> stream, Collector<? super T, ?, ? extends Collection<?>> collector) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() == 0L, stream.count() <= 0L, stream.count() < 1L, stream.findFirst().isEmpty(), stream.collect(collector).isEmpty()});
        }

        boolean after(Stream<T> stream) {
            return stream.findAny().isEmpty();
        }
    }

    static final class StreamMapFirst<T, S> {
        StreamMapFirst() {
        }

        Optional<S> before(Stream<T> stream, Function<? super T, S> function) {
            return stream.map(function).findFirst();
        }

        Optional<S> after(Stream<T> stream, Function<? super T, S> function) {
            return stream.findFirst().map(function);
        }
    }

    static final class StreamFilterSortedWithComparator<T> {
        StreamFilterSortedWithComparator() {
        }

        Stream<T> before(Stream<T> stream, Predicate<? super T> predicate, Comparator<? super T> comparator) {
            return stream.sorted(comparator).filter(predicate);
        }

        Stream<T> after(Stream<T> stream, Predicate<? super T> predicate, Comparator<? super T> comparator) {
            return stream.filter(predicate).sorted(comparator);
        }
    }

    static final class StreamFilterSorted<T> {
        StreamFilterSorted() {
        }

        Stream<T> before(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.sorted().filter(predicate);
        }

        Stream<T> after(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.filter(predicate).sorted();
        }
    }

    static abstract class FlatMapOuterStreamAfterFlatMap<T, S, R> {
        FlatMapOuterStreamAfterFlatMap() {
        }

        abstract Stream<S> toStreamFunction(T var1);

        Stream<R> before(Stream<T> stream, Function<? super S, ? extends Stream<? extends R>> function) {
            return stream.flatMap(v -> this.toStreamFunction(v).flatMap(function));
        }

        Stream<R> after(Stream<T> stream, Function<? super S, ? extends Stream<? extends R>> function) {
            return stream.flatMap(v -> this.toStreamFunction(v)).flatMap(function);
        }
    }

    static abstract class MapOuterStreamAfterFlatMap<T, S, R> {
        MapOuterStreamAfterFlatMap() {
        }

        abstract Stream<S> toStreamFunction(T var1);

        Stream<R> before(Stream<T> stream, Function<? super S, ? extends R> function) {
            return stream.flatMap(v -> this.toStreamFunction(v).map(function));
        }

        Stream<R> after(Stream<T> stream, Function<? super S, ? extends R> function) {
            return stream.flatMap(v -> this.toStreamFunction(v)).map(function);
        }
    }

    static abstract class FilterOuterStreamAfterFlatMap<T, S> {
        FilterOuterStreamAfterFlatMap() {
        }

        abstract Stream<S> toStreamFunction(T var1);

        Stream<S> before(Stream<T> stream, Predicate<? super S> predicate) {
            return stream.flatMap(v -> this.toStreamFunction(v).filter(predicate));
        }

        Stream<S> after(Stream<T> stream, Predicate<? super S> predicate) {
            return stream.flatMap(v -> this.toStreamFunction(v)).filter(predicate);
        }
    }

    static final class ConcatTwoStreams<T> {
        ConcatTwoStreams() {
        }

        Stream<T> before(Stream<T> s1, Stream<T> s2) {
            return Streams.concat((Stream[])new Stream[]{s1, s2});
        }

        Stream<T> after(Stream<T> s1, Stream<T> s2) {
            return Stream.concat(s1, s2);
        }
    }

    static final class ConcatOneStream<T> {
        ConcatOneStream() {
        }

        Stream<T> before(Stream<T> stream) {
            return Streams.concat((Stream[])new Stream[]{stream});
        }

        @CanIgnoreReturnValue
        Stream<T> after(Stream<T> stream) {
            return stream;
        }
    }

    static final class StreamOfArray<T> {
        StreamOfArray() {
        }

        Stream<T> before(T[] array) {
            return Stream.of(array);
        }

        Stream<T> after(T[] array) {
            return Arrays.stream(array);
        }
    }

    static final class StreamOfNullable<T> {
        StreamOfNullable() {
        }

        Stream<T> before(T object) {
            return (Stream)Refaster.anyOf((Object[])new Stream[]{Stream.of(object).filter(Objects::nonNull), Optional.ofNullable(object).stream()});
        }

        Stream<T> after(T object) {
            return Stream.ofNullable(object);
        }
    }

    static final class EmptyStream<T> {
        EmptyStream() {
        }

        Stream<T> before() {
            return Stream.of(new Object[0]);
        }

        Stream<T> after() {
            return Stream.empty();
        }
    }

    static final class Joining {
        Joining() {
        }

        Collector<CharSequence, ?, String> before() {
            return Collectors.joining("");
        }

        Collector<CharSequence, ?, String> after() {
            return Collectors.joining();
        }
    }
}

