/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.collect.Maps;
import com.google.errorprone.refaster.Refaster;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;

final class MapEntryTemplates {
    private MapEntryTemplates() {
    }

    static final class MapEntryComparingByValueWithCustomComparator<K, V> {
        MapEntryComparingByValueWithCustomComparator() {
        }

        Comparator<Map.Entry<K, V>> before(Comparator<? super V> cmp) {
            return Comparator.comparing(Map.Entry::getValue, cmp);
        }

        Comparator<Map.Entry<K, V>> after(Comparator<? super V> cmp) {
            return Map.Entry.comparingByValue(cmp);
        }
    }

    static final class MapEntryComparingByValue<K, V extends Comparable<? super V>> {
        MapEntryComparingByValue() {
        }

        Comparator<Map.Entry<K, V>> before() {
            return (Comparator)Refaster.anyOf((Object[])new Comparator[]{Comparator.comparing(Map.Entry::getValue), Map.Entry.comparingByValue(Comparator.naturalOrder())});
        }

        Comparator<Map.Entry<K, V>> after() {
            return Map.Entry.comparingByValue();
        }
    }

    static final class MapEntryComparingByKeyWithCustomComparator<K, V> {
        MapEntryComparingByKeyWithCustomComparator() {
        }

        Comparator<Map.Entry<K, V>> before(Comparator<? super K> cmp) {
            return Comparator.comparing(Map.Entry::getKey, cmp);
        }

        Comparator<Map.Entry<K, V>> after(Comparator<? super K> cmp) {
            return Map.Entry.comparingByKey(cmp);
        }
    }

    static final class MapEntryComparingByKey<K extends Comparable<? super K>, V> {
        MapEntryComparingByKey() {
        }

        Comparator<Map.Entry<K, V>> before() {
            return (Comparator)Refaster.anyOf((Object[])new Comparator[]{Comparator.comparing(Map.Entry::getKey), Map.Entry.comparingByKey(Comparator.naturalOrder())});
        }

        Comparator<Map.Entry<K, V>> after() {
            return Map.Entry.comparingByKey();
        }
    }

    static final class MapEntry<K, V> {
        MapEntry() {
        }

        Map.Entry<K, V> before(K key, V value) {
            return (Map.Entry)Refaster.anyOf((Object[])new Map.Entry[]{Maps.immutableEntry(key, value), new AbstractMap.SimpleImmutableEntry<K, V>(key, value)});
        }

        Map.Entry<K, V> after(K key, V value) {
            return Map.entry(key, value);
        }
    }
}

