/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

final class ComparatorTemplates {
    private ComparatorTemplates() {
    }

    static final class MaxOfPairCustomOrder<T> {
        MaxOfPairCustomOrder() {
        }

        T before(T value1, T value2, Comparator<T> cmp) {
            return Collections.max((Collection)Refaster.anyOf((Object[])new Collection[]{Arrays.asList(value1, value2), ImmutableList.of(value1, value2), ImmutableSet.of(value1, value2)}), cmp);
        }

        T after(T value1, T value2, Comparator<T> cmp) {
            return (T)Comparators.max(value1, value2, cmp);
        }
    }

    static final class MaxOfPairNaturalOrder<T extends Comparable<? super T>> {
        MaxOfPairNaturalOrder() {
        }

        T before(T value1, T value2) {
            return (T)((Comparable)Collections.max((Collection)Refaster.anyOf((Object[])new Collection[]{Arrays.asList(value1, value2), ImmutableList.of(value1, value2), ImmutableSet.of(value1, value2)})));
        }

        T after(T value1, T value2) {
            return (T)Comparators.max(value1, value2);
        }
    }

    static final class MinOfPairCustomOrder<T> {
        MinOfPairCustomOrder() {
        }

        T before(T value1, T value2, Comparator<T> cmp) {
            return Collections.min((Collection)Refaster.anyOf((Object[])new Collection[]{Arrays.asList(value1, value2), ImmutableList.of(value1, value2), ImmutableSet.of(value1, value2)}), cmp);
        }

        T after(T value1, T value2, Comparator<T> cmp) {
            return (T)Comparators.min(value1, value2, cmp);
        }
    }

    static final class MinOfPairNaturalOrder<T extends Comparable<? super T>> {
        MinOfPairNaturalOrder() {
        }

        T before(T value1, T value2) {
            return (T)((Comparable)Collections.min((Collection)Refaster.anyOf((Object[])new Collection[]{Arrays.asList(value1, value2), ImmutableList.of(value1, value2), ImmutableSet.of(value1, value2)})));
        }

        T after(T value1, T value2) {
            return (T)Comparators.min(value1, value2);
        }
    }

    static final class ThenComparingNaturalOrder<T extends Comparable<? super T>> {
        ThenComparingNaturalOrder() {
        }

        Comparator<T> before(Comparator<T> cmp) {
            return cmp.thenComparing((Function)Refaster.anyOf((Object[])new Function[]{Function.identity(), v -> v}));
        }

        Comparator<T> after(Comparator<T> cmp) {
            return cmp.thenComparing(Comparator.naturalOrder());
        }
    }

    static final class ThenComparingLong<T> {
        ThenComparingLong() {
        }

        Comparator<T> before(Comparator<T> cmp, ToLongFunction<? super T> function) {
            return cmp.thenComparing(Comparator.comparingLong(function));
        }

        Comparator<T> after(Comparator<T> cmp, ToLongFunction<? super T> function) {
            return cmp.thenComparingLong(function);
        }
    }

    static final class ThenComparingInt<T> {
        ThenComparingInt() {
        }

        Comparator<T> before(Comparator<T> cmp, ToIntFunction<? super T> function) {
            return cmp.thenComparing(Comparator.comparingInt(function));
        }

        Comparator<T> after(Comparator<T> cmp, ToIntFunction<? super T> function) {
            return cmp.thenComparingInt(function);
        }
    }

    static final class ThenComparingDouble<T> {
        ThenComparingDouble() {
        }

        Comparator<T> before(Comparator<T> cmp, ToDoubleFunction<? super T> function) {
            return cmp.thenComparing(Comparator.comparingDouble(function));
        }

        Comparator<T> after(Comparator<T> cmp, ToDoubleFunction<? super T> function) {
            return cmp.thenComparingDouble(function);
        }
    }

    static final class ThenComparingCustomReversed<S, T> {
        ThenComparingCustomReversed() {
        }

        Comparator<S> before(Comparator<S> cmp, Function<? super S, ? extends T> function, Comparator<? super T> cmp2) {
            return cmp.thenComparing(Comparator.comparing(function, cmp2).reversed());
        }

        Comparator<S> after(Comparator<S> cmp, Function<? super S, ? extends T> function, Comparator<? super T> cmp2) {
            return cmp.thenComparing(function, cmp2.reversed());
        }
    }

    static final class ThenComparingCustom<S, T> {
        ThenComparingCustom() {
        }

        Comparator<S> before(Comparator<S> cmp, Function<? super S, ? extends T> function, Comparator<? super T> cmp2) {
            return cmp.thenComparing(Comparator.comparing(function, cmp2));
        }

        Comparator<S> after(Comparator<S> cmp, Function<? super S, ? extends T> function, Comparator<? super T> cmp2) {
            return cmp.thenComparing(function, cmp2);
        }
    }

    static final class ThenComparingReversed<S, T extends Comparable<? super T>> {
        ThenComparingReversed() {
        }

        Comparator<S> before(Comparator<S> cmp, Function<? super S, ? extends T> function) {
            return cmp.thenComparing(Comparator.comparing(function).reversed());
        }

        Comparator<S> after(Comparator<S> cmp, Function<? super S, ? extends T> function) {
            return cmp.thenComparing(function, Comparator.reverseOrder());
        }
    }

    static final class ThenComparing<S, T extends Comparable<? super T>> {
        ThenComparing() {
        }

        Comparator<S> before(Comparator<S> cmp, Function<? super S, ? extends T> function) {
            return cmp.thenComparing(Comparator.comparing(function));
        }

        Comparator<S> after(Comparator<S> cmp, Function<? super S, ? extends T> function) {
            return cmp.thenComparing(function);
        }
    }

    static final class CustomComparator<T> {
        CustomComparator() {
        }

        Comparator<T> before(Comparator<T> cmp) {
            return Comparator.comparing((Function)Refaster.anyOf((Object[])new Function[]{Function.identity(), v -> v}), cmp);
        }

        Comparator<T> after(Comparator<T> cmp) {
            return cmp;
        }
    }

    static final class ReverseOrder<T extends Comparable<? super T>> {
        ReverseOrder() {
        }

        Comparator<T> before() {
            return Comparator.naturalOrder().reversed();
        }

        Comparator<T> after() {
            return Comparator.reverseOrder();
        }
    }

    static final class NaturalOrder<T extends Comparable<? super T>> {
        NaturalOrder() {
        }

        Comparator<T> before() {
            return (Comparator)Refaster.anyOf((Object[])new Comparator[]{Comparator.comparing((Function)Refaster.anyOf((Object[])new Function[]{Function.identity(), v -> v})), Comparator.reverseOrder().reversed()});
        }

        Comparator<T> after() {
            return Comparator.naturalOrder();
        }
    }
}

