/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.errorprone.refaster.Refaster;
import java.math.BigDecimal;

final class BigDecimalTemplates {
    private BigDecimalTemplates() {
    }

    static final class BigDecimalFactoryMethod {
        BigDecimalFactoryMethod() {
        }

        BigDecimal before(long value) {
            return new BigDecimal(value);
        }

        BigDecimal after(long value) {
            return BigDecimal.valueOf(value);
        }
    }

    static final class BigDecimalTen {
        BigDecimalTen() {
        }

        BigDecimal before() {
            return (BigDecimal)Refaster.anyOf((Object[])new BigDecimal[]{BigDecimal.valueOf(10L), new BigDecimal("10")});
        }

        BigDecimal after() {
            return BigDecimal.TEN;
        }
    }

    static final class BigDecimalOne {
        BigDecimalOne() {
        }

        BigDecimal before() {
            return (BigDecimal)Refaster.anyOf((Object[])new BigDecimal[]{BigDecimal.valueOf(1L), new BigDecimal("1")});
        }

        BigDecimal after() {
            return BigDecimal.ONE;
        }
    }

    static final class BigDecimalZero {
        BigDecimalZero() {
        }

        BigDecimal before() {
            return (BigDecimal)Refaster.anyOf((Object[])new BigDecimal[]{BigDecimal.valueOf(0L), new BigDecimal("0")});
        }

        BigDecimal after() {
            return BigDecimal.ZERO;
        }
    }
}

