/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.errorprone.refaster.Refaster;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBigIntegerAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.NumberAssert;

final class AssertJNumberTemplates {
    private AssertJNumberTemplates() {
    }

    static final class AssertThatIsEven {
        AssertThatIsEven() {
        }

        AbstractIntegerAssert<?> before(int number) {
            return Assertions.assertThat((int)(number % 2)).isEqualTo(0);
        }

        AbstractLongAssert<?> before(long number) {
            return Assertions.assertThat((long)(number % 2L)).isEqualTo(0L);
        }

        NumberAssert<?, ?> after(long number) {
            return Assertions.assertThat((long)number).isEven();
        }
    }

    static final class AssertThatIsOdd {
        AssertThatIsOdd() {
        }

        AbstractIntegerAssert<?> before(int number) {
            return Assertions.assertThat((int)(number % 2)).isEqualTo(1);
        }

        AbstractLongAssert<?> before(long number) {
            return Assertions.assertThat((long)(number % 2L)).isEqualTo(1L);
        }

        NumberAssert<?, ?> after(long number) {
            return Assertions.assertThat((long)number).isOdd();
        }
    }

    static final class NumberAssertIsNotNegative {
        NumberAssertIsNotNegative() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {
            return (AbstractByteAssert)Refaster.anyOf((Object[])new AbstractByteAssert[]{numberAssert.isGreaterThanOrEqualTo((byte)0), numberAssert.isGreaterThan((byte)-1)});
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{numberAssert.isGreaterThanOrEqualTo((short)0), numberAssert.isGreaterThan((short)-1)});
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{numberAssert.isGreaterThanOrEqualTo(0), numberAssert.isGreaterThan(-1)});
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{numberAssert.isGreaterThanOrEqualTo(0L), numberAssert.isGreaterThan(-1L)});
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {
            return numberAssert.isGreaterThanOrEqualTo(0.0f);
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {
            return numberAssert.isGreaterThanOrEqualTo(0.0);
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{(AbstractBigIntegerAssert)numberAssert.isGreaterThanOrEqualTo((Comparable)BigInteger.ZERO), (AbstractBigIntegerAssert)numberAssert.isGreaterThan((Comparable)BigInteger.valueOf(-1L))});
        }

        AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {
            return numberAssert.isGreaterThanOrEqualTo(BigDecimal.ZERO);
        }

        NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {
            return numberAssert.isNotNegative();
        }
    }

    static final class NumberAssertIsNegative {
        NumberAssertIsNegative() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {
            return (AbstractByteAssert)Refaster.anyOf((Object[])new AbstractByteAssert[]{numberAssert.isLessThan((byte)0), numberAssert.isLessThanOrEqualTo((byte)-1)});
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{numberAssert.isLessThan((short)0), numberAssert.isLessThanOrEqualTo((short)-1)});
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{numberAssert.isLessThan(0), numberAssert.isLessThanOrEqualTo(-1)});
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{numberAssert.isLessThan(0L), numberAssert.isLessThanOrEqualTo(-1L)});
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {
            return numberAssert.isLessThan(0.0f);
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {
            return numberAssert.isLessThan(0.0);
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{(AbstractBigIntegerAssert)numberAssert.isLessThan((Comparable)BigInteger.ZERO), (AbstractBigIntegerAssert)numberAssert.isLessThanOrEqualTo((Comparable)BigInteger.valueOf(-1L))});
        }

        AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {
            return (AbstractBigDecimalAssert)numberAssert.isLessThan((Comparable)BigDecimal.ZERO);
        }

        NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {
            return numberAssert.isNegative();
        }
    }

    static final class NumberAssertIsNotPositive {
        NumberAssertIsNotPositive() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {
            return (AbstractByteAssert)Refaster.anyOf((Object[])new AbstractByteAssert[]{numberAssert.isLessThanOrEqualTo((byte)0), numberAssert.isLessThan((byte)1)});
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{numberAssert.isLessThanOrEqualTo((short)0), numberAssert.isLessThan((short)1)});
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{numberAssert.isLessThanOrEqualTo(0), numberAssert.isLessThan(1)});
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{numberAssert.isLessThanOrEqualTo(0L), numberAssert.isLessThan(1L)});
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {
            return numberAssert.isLessThanOrEqualTo(0.0f);
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {
            return numberAssert.isLessThanOrEqualTo(0.0);
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{(AbstractBigIntegerAssert)numberAssert.isLessThanOrEqualTo((Comparable)BigInteger.ZERO), (AbstractBigIntegerAssert)numberAssert.isLessThan((Comparable)BigInteger.valueOf(1L))});
        }

        AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {
            return numberAssert.isLessThanOrEqualTo(BigDecimal.ZERO);
        }

        NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {
            return numberAssert.isNotPositive();
        }
    }

    static final class NumberAssertIsPositive {
        NumberAssertIsPositive() {
        }

        AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {
            return (AbstractByteAssert)Refaster.anyOf((Object[])new AbstractByteAssert[]{numberAssert.isGreaterThan((byte)0), numberAssert.isGreaterThanOrEqualTo((byte)1)});
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{numberAssert.isGreaterThan((short)0), numberAssert.isGreaterThanOrEqualTo((short)1)});
        }

        AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{numberAssert.isGreaterThan(0), numberAssert.isGreaterThanOrEqualTo(1)});
        }

        AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{numberAssert.isGreaterThan(0L), numberAssert.isGreaterThanOrEqualTo(1L)});
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {
            return numberAssert.isGreaterThan(0.0f);
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {
            return numberAssert.isGreaterThan(0.0);
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{(AbstractBigIntegerAssert)numberAssert.isGreaterThan((Comparable)BigInteger.ZERO), (AbstractBigIntegerAssert)numberAssert.isGreaterThanOrEqualTo((Comparable)BigInteger.valueOf(1L))});
        }

        AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {
            return (AbstractBigDecimalAssert)numberAssert.isGreaterThan((Comparable)BigDecimal.ZERO);
        }

        NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {
            return numberAssert.isPositive();
        }
    }
}

