/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

final class AssertJCharSequenceTemplates {
    private AssertJCharSequenceTemplates() {
    }

    static final class AssertThatCharSequenceHasSize {
        AssertThatCharSequenceHasSize() {
        }

        AbstractAssert<?, ?> before(CharSequence charSequence, int length) {
            return Assertions.assertThat((int)charSequence.length()).isEqualTo(length);
        }

        AbstractAssert<?, ?> after(CharSequence charSequence, int length) {
            return Assertions.assertThat((CharSequence)charSequence).hasSize(length);
        }
    }

    static final class AssertThatCharSequenceIsNotEmpty {
        AssertThatCharSequenceIsNotEmpty() {
        }

        AbstractAssert<?, ?> before(CharSequence charSequence) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{Assertions.assertThat((int)charSequence.length()).isNotEqualTo(0), Assertions.assertThat((int)charSequence.length()).isPositive()});
        }

        AbstractAssert<?, ?> after(CharSequence charSequence) {
            return Assertions.assertThat((CharSequence)charSequence).isNotEmpty();
        }
    }

    static final class AssertThatCharSequenceIsEmpty {
        AssertThatCharSequenceIsEmpty() {
        }

        void before(CharSequence charSequence) {
            Refaster.anyOf((Object[])new AbstractIntegerAssert[]{Assertions.assertThat((int)charSequence.length()).isEqualTo(0L), Assertions.assertThat((int)charSequence.length()).isNotPositive()});
        }

        void after(CharSequence charSequence) {
            Assertions.assertThat((CharSequence)charSequence).isEmpty();
        }
    }
}

