/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.refaster.Refaster;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="`Refaster#anyOf` should be passed at least two parameters", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class RefasterAnyOfUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> REFASTER_ANY_OF = MethodMatchers.staticMethod().onClass(Refaster.class.getName()).named("anyOf");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (REFASTER_ANY_OF.matches((Tree)tree, state)) {
            switch (tree.getArguments().size()) {
                case 0: {
                    return this.describeMatch(tree);
                }
                case 1: {
                    return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)SourceCode.treeToString(tree.getArguments().get(0), state)));
                }
            }
        }
        return Description.NO_MATCH;
    }
}

