/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import java.net.URI;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.documentation.Extractor;

@Immutable
@AutoService(value={Extractor.class})
public final class BugPatternTestExtractor
implements Extractor<BugPatternTestCases> {
    @Override
    public String identifier() {
        return "bugpattern-test";
    }

    @Override
    public Optional<BugPatternTestCases> tryExtract(ClassTree tree, VisitorState state) {
        BugPatternTestCollector collector = new BugPatternTestCollector();
        collector.scan(tree, state);
        return Optional.of(collector.getCollectedTests()).filter(Predicate.not(AbstractCollection::isEmpty)).map(tests -> new BugPatternTestCases(state.getPath().getCompilationUnit().getSourceFile().toUri(), ASTHelpers.getSymbol((ClassTree)tree).className(), (ImmutableList<BugPatternTestCase>)tests));
    }

    private static final class BugPatternTestCollector
    extends TreeScanner<Void, VisitorState> {
        private static final Matcher<ExpressionTree> COMPILATION_HELPER_DO_TEST = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.CompilationTestHelper").named("doTest");
        private static final Matcher<ExpressionTree> TEST_HELPER_NEW_INSTANCE = MethodMatchers.staticMethod().onDescendantOfAny(new String[]{"com.google.errorprone.CompilationTestHelper", "com.google.errorprone.BugCheckerRefactoringTestHelper"}).named("newInstance").withParameters(Class.class.getCanonicalName(), new String[]{Class.class.getCanonicalName()});
        private static final Matcher<ExpressionTree> IDENTIFICATION_SOURCE_LINES = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.CompilationTestHelper").named("addSourceLines");
        private static final Matcher<ExpressionTree> REPLACEMENT_DO_TEST = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper").named("doTest");
        private static final Matcher<ExpressionTree> REPLACEMENT_EXPECT_UNCHANGED = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput").named("expectUnchanged");
        private static final Matcher<ExpressionTree> REPLACEMENT_OUTPUT_SOURCE_LINES = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput").namedAnyOf(new String[]{"addOutputLines", "expectUnchanged"});
        private final List<BugPatternTestCase> collectedBugPatternTestCases = new ArrayList<BugPatternTestCase>();

        private BugPatternTestCollector() {
        }

        private ImmutableList<BugPatternTestCase> getCollectedTests() {
            return ImmutableList.copyOf(this.collectedBugPatternTestCases);
        }

        @Override
        public @Nullable Void visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            boolean isReplacementTest = REPLACEMENT_DO_TEST.matches((Tree)node, state);
            if (isReplacementTest || COMPILATION_HELPER_DO_TEST.matches((Tree)node, state)) {
                BugPatternTestCollector.getClassUnderTest(node, state).ifPresent(classUnderTest -> {
                    ArrayList<TestEntry> entries = new ArrayList<TestEntry>();
                    if (isReplacementTest) {
                        BugPatternTestCollector.extractReplacementBugPatternTestCases(node, entries, state);
                    } else {
                        BugPatternTestCollector.extractIdentificationBugPatternTestCases(node, entries, state);
                    }
                    if (!entries.isEmpty()) {
                        this.collectedBugPatternTestCases.add(new BugPatternTestCase((String)classUnderTest, (ImmutableList<TestEntry>)ImmutableList.copyOf(entries).reverse()));
                    }
                });
            }
            return (Void)super.visitMethodInvocation(node, state);
        }

        private static Optional<String> getClassUnderTest(MethodInvocationTree tree, VisitorState state) {
            Optional<String> optional;
            if (TEST_HELPER_NEW_INSTANCE.matches((Tree)tree, state)) {
                return Optional.ofNullable(ASTHelpers.getSymbol((Tree)tree.getArguments().getFirst())).filter(s -> !s.type.allparams().isEmpty()).map(s -> ((Type)s.type.allparams().getFirst()).tsym.getQualifiedName().toString());
            }
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            if (receiver instanceof MethodInvocationTree) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)receiver;
                optional = BugPatternTestCollector.getClassUnderTest(methodInvocation, state);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        private static void extractIdentificationBugPatternTestCases(MethodInvocationTree tree, List<TestEntry> sink, VisitorState state) {
            ExpressionTree receiver;
            if (IDENTIFICATION_SOURCE_LINES.matches((Tree)tree, state)) {
                String path = (String)ASTHelpers.constValue((Tree)tree.getArguments().getFirst(), String.class);
                Optional<String> sourceCode = BugPatternTestCollector.getSourceCode(tree).filter(s -> s.contains("// BUG: Diagnostic"));
                if (path != null && sourceCode.isPresent()) {
                    sink.add(new IdentificationTestEntry(path, sourceCode.orElseThrow()));
                }
            }
            if ((receiver = ASTHelpers.getReceiver((ExpressionTree)tree)) instanceof MethodInvocationTree) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)receiver;
                BugPatternTestCollector.extractIdentificationBugPatternTestCases(methodInvocation, sink, state);
            }
        }

        private static void extractReplacementBugPatternTestCases(MethodInvocationTree tree, List<TestEntry> sink, VisitorState state) {
            ExpressionTree receiver;
            if (REPLACEMENT_OUTPUT_SOURCE_LINES.matches((Tree)tree, state)) {
                MethodInvocationTree inputTree = (MethodInvocationTree)Objects.requireNonNull(ASTHelpers.getReceiver((ExpressionTree)tree), "Instance method invocation must have receiver");
                String path = (String)ASTHelpers.constValue((Tree)inputTree.getArguments().getFirst(), String.class);
                Optional<String> inputCode = BugPatternTestCollector.getSourceCode(inputTree);
                if (path != null && inputCode.isPresent()) {
                    Optional<String> outputCode;
                    Optional<String> optional = outputCode = REPLACEMENT_EXPECT_UNCHANGED.matches((Tree)tree, state) ? inputCode : BugPatternTestCollector.getSourceCode(tree);
                    if (outputCode.isPresent() && !inputCode.equals(outputCode)) {
                        sink.add(new ReplacementTestEntry(path, inputCode.orElseThrow(), outputCode.orElseThrow()));
                    }
                }
            }
            if ((receiver = ASTHelpers.getReceiver((ExpressionTree)tree)) instanceof MethodInvocationTree) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)receiver;
                BugPatternTestCollector.extractReplacementBugPatternTestCases(methodInvocation, sink, state);
            }
        }

        private static Optional<String> getSourceCode(MethodInvocationTree tree) {
            List<? extends ExpressionTree> sourceLines = tree.getArguments().subList(1, tree.getArguments().size());
            StringBuilder source = new StringBuilder();
            for (ExpressionTree expressionTree : sourceLines) {
                String value = (String)ASTHelpers.constValue((Tree)expressionTree, String.class);
                if (value == null) {
                    return Optional.empty();
                }
                source.append(value).append('\n');
            }
            return Optional.of(source.toString());
        }
    }

    record BugPatternTestCases(URI source, String testClass, ImmutableList<BugPatternTestCase> testCases) {
    }

    record ReplacementTestEntry(String path, String input, String output) implements TestEntry
    {
        @Override
        @JsonProperty
        public TestEntry.TestType type() {
            return TestEntry.TestType.REPLACEMENT;
        }
    }

    record IdentificationTestEntry(String path, String code) implements TestEntry
    {
        @Override
        @JsonProperty
        public TestEntry.TestType type() {
            return TestEntry.TestType.IDENTIFICATION;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(value={"type"})
    @JsonSubTypes(value={@JsonSubTypes.Type(value=IdentificationTestEntry.class), @JsonSubTypes.Type(value=ReplacementTestEntry.class)})
    @JsonTypeInfo(include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", use=JsonTypeInfo.Id.DEDUCTION)
    static interface TestEntry {
        public TestType type();

        public String path();

        public static enum TestType {
            IDENTIFICATION,
            REPLACEMENT;

        }
    }

    record BugPatternTestCase(String classUnderTest, ImmutableList<TestEntry> entries) {
    }
}

