/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.google.auto.service.AutoService;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tech.picnic.errorprone.documentation.Extractor;
import tech.picnic.errorprone.utils.SourceCode;

@Immutable
@AutoService(value={Extractor.class})
public final class RefasterRuleCollectionTestExtractor
implements Extractor<RefasterTestCases> {
    private static final com.google.errorprone.matchers.Matcher<ClassTree> IS_REFASTER_RULE_COLLECTION_TEST_CASE = Matchers.isSubtypeOf((String)"tech.picnic.errorprone.refaster.test.RefasterRuleCollectionTestCase");
    private static final Pattern TEST_CLASS_NAME_PATTERN = Pattern.compile("(.*)Test");
    private static final Pattern TEST_CLASS_FILE_NAME_PATTERN = Pattern.compile(".*(Input|Output)\\.java");
    private static final Pattern TEST_METHOD_NAME_PATTERN = Pattern.compile("test(.*)");
    private static final String LINE_SEPARATOR = "\n";
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n");

    @Override
    public String identifier() {
        return "refaster-rule-collection-test";
    }

    @Override
    public Optional<RefasterTestCases> tryExtract(ClassTree tree, VisitorState state) {
        if (!IS_REFASTER_RULE_COLLECTION_TEST_CASE.matches((Tree)tree, state)) {
            return Optional.empty();
        }
        URI sourceFile = state.getPath().getCompilationUnit().getSourceFile().toUri();
        return Optional.of(new RefasterTestCases(sourceFile, RefasterRuleCollectionTestExtractor.getRuleCollectionName(tree), RefasterRuleCollectionTestExtractor.isInputFile(sourceFile), RefasterRuleCollectionTestExtractor.getRefasterTestCases(tree, state)));
    }

    private static String getRuleCollectionName(ClassTree tree) {
        String className = tree.getSimpleName().toString();
        return RefasterRuleCollectionTestExtractor.tryExtractPatternGroup(className, TEST_CLASS_NAME_PATTERN).orElseThrow(RefasterRuleCollectionTestExtractor.violation("Refaster rule collection test class name '%s' does not match '%s'", className, TEST_CLASS_NAME_PATTERN));
    }

    private static boolean isInputFile(URI sourceFile) {
        String path = sourceFile.getPath();
        return "Input".equals(RefasterRuleCollectionTestExtractor.tryExtractPatternGroup(path, TEST_CLASS_FILE_NAME_PATTERN).orElseThrow(RefasterRuleCollectionTestExtractor.violation("Refaster rule collection test file name '%s' does not match '%s'", path, TEST_CLASS_FILE_NAME_PATTERN)));
    }

    private static ImmutableList<RefasterTestCase> getRefasterTestCases(ClassTree tree, VisitorState state) {
        return (ImmutableList)tree.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).flatMap(m -> RefasterRuleCollectionTestExtractor.tryExtractRefasterTestCase(m, state).stream()).collect(ImmutableList.toImmutableList());
    }

    private static Optional<RefasterTestCase> tryExtractRefasterTestCase(MethodTree method, VisitorState state) {
        return RefasterRuleCollectionTestExtractor.tryExtractPatternGroup(method.getName().toString(), TEST_METHOD_NAME_PATTERN).map(name -> new RefasterTestCase((String)name, RefasterRuleCollectionTestExtractor.getFormattedSource(method, state)));
    }

    private static String getFormattedSource(MethodTree method, VisitorState state) {
        String source = SourceCode.treeToString((Tree)method, (VisitorState)state);
        int finalNewline = source.lastIndexOf(LINE_SEPARATOR);
        if (finalNewline < 0) {
            return source;
        }
        int indentation = Math.max(0, source.lastIndexOf(32) - finalNewline);
        String prefixToStrip = " ".repeat(indentation);
        return LINE_SPLITTER.splitToStream((CharSequence)source).map(line -> line.startsWith(prefixToStrip) ? line.substring(indentation) : line).collect(Collectors.joining(LINE_SEPARATOR));
    }

    private static Optional<String> tryExtractPatternGroup(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        return matcher.matches() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    @FormatMethod
    private static Supplier<VerifyException> violation(String format, Object ... args) {
        return () -> new VerifyException(String.format(format, args));
    }

    record RefasterTestCases(URI source, String ruleCollection, boolean isInput, ImmutableList<RefasterTestCase> testCases) {
    }

    record RefasterTestCase(String name, String content) {
    }
}

