/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.common.AnnotationMirrors;
import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import tech.picnic.errorprone.documentation.AutoValue_BugPatternExtractor_BugPatternDocumentation;
import tech.picnic.errorprone.documentation.Extractor;

@Immutable
@AutoService(value={Extractor.class})
public final class BugPatternExtractor
implements Extractor<BugPatternDocumentation> {
    @Override
    public String identifier() {
        return "bugpattern";
    }

    @Override
    public Optional<BugPatternDocumentation> tryExtract(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        BugPattern annotation = symbol.getAnnotation(BugPattern.class);
        if (annotation == null) {
            return Optional.empty();
        }
        return Optional.of(BugPatternDocumentation.create(state.getPath().getCompilationUnit().getSourceFile().toUri(), symbol.getQualifiedName().toString(), annotation.name().isEmpty() ? tree.getSimpleName().toString() : annotation.name(), (ImmutableList<String>)ImmutableList.copyOf((Object[])annotation.altNames()), annotation.link(), (ImmutableList<String>)ImmutableList.copyOf((Object[])annotation.tags()), annotation.summary(), annotation.explanation(), annotation.severity(), annotation.disableable(), annotation.documentSuppression() ? BugPatternExtractor.getSuppressionAnnotations(tree) : ImmutableList.of()));
    }

    private static ImmutableList<String> getSuppressionAnnotations(ClassTree tree) {
        AnnotationTree annotationTree = ASTHelpers.getAnnotationWithSimpleName((List)ASTHelpers.getAnnotations((Tree)tree), (String)BugPattern.class.getSimpleName());
        Objects.requireNonNull(annotationTree, "BugPattern annotation must be present");
        Attribute.Array types = BugPatternExtractor.doCast(AnnotationMirrors.getAnnotationValue((AnnotationMirror)ASTHelpers.getAnnotationMirror((AnnotationTree)annotationTree), (String)"suppressionAnnotations"), Attribute.Array.class);
        return (ImmutableList)types.getValue().stream().map(v -> BugPatternExtractor.doCast((AnnotationValue)v, Attribute.Class.class).classType.toString()).collect(ImmutableList.toImmutableList());
    }

    private static <T extends AnnotationValue> T doCast(AnnotationValue value, Class<T> target) {
        Verify.verify((boolean)target.isInstance(value), (String)"Value '%s' is not of type '%s'", (Object)value, target);
        return (T)value;
    }

    @JsonDeserialize(as=AutoValue_BugPatternExtractor_BugPatternDocumentation.class)
    @AutoValue
    static abstract class BugPatternDocumentation {
        BugPatternDocumentation() {
        }

        static BugPatternDocumentation create(URI source, String fullyQualifiedName, String name, ImmutableList<String> altNames, String link, ImmutableList<String> tags, String summary, String explanation, BugPattern.SeverityLevel severityLevel, boolean canDisable, ImmutableList<String> suppressionAnnotations) {
            return new AutoValue_BugPatternExtractor_BugPatternDocumentation(source, fullyQualifiedName, name, altNames, link, tags, summary, explanation, severityLevel, canDisable, suppressionAnnotations);
        }

        abstract URI source();

        abstract String fullyQualifiedName();

        abstract String name();

        abstract ImmutableList<String> altNames();

        abstract String link();

        abstract ImmutableList<String> tags();

        abstract String summary();

        abstract String explanation();

        abstract BugPattern.SeverityLevel severityLevel();

        abstract boolean canDisable();

        abstract ImmutableList<String> suppressionAnnotations();
    }
}

