/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import java.net.URI;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.documentation.AutoValue_BugPatternTestExtractor_IdentificationTestEntry;
import tech.picnic.errorprone.documentation.AutoValue_BugPatternTestExtractor_ReplacementTestEntry;
import tech.picnic.errorprone.documentation.AutoValue_BugPatternTestExtractor_TestCase;
import tech.picnic.errorprone.documentation.AutoValue_BugPatternTestExtractor_TestCases;
import tech.picnic.errorprone.documentation.Extractor;

@Immutable
@AutoService(value={Extractor.class})
public final class BugPatternTestExtractor
implements Extractor<TestCases> {
    @Override
    public String identifier() {
        return "bugpattern-test";
    }

    @Override
    public Optional<TestCases> tryExtract(ClassTree tree, VisitorState state) {
        BugPatternTestCollector collector = new BugPatternTestCollector();
        collector.scan(tree, state);
        return Optional.of(collector.getCollectedTests()).filter(Predicate.not(AbstractCollection::isEmpty)).map(tests -> new AutoValue_BugPatternTestExtractor_TestCases(state.getPath().getCompilationUnit().getSourceFile().toUri(), ASTHelpers.getSymbol((ClassTree)tree).className(), (ImmutableList<TestCase>)tests));
    }

    private static final class BugPatternTestCollector
    extends TreeScanner<Void, VisitorState> {
        private static final Matcher<ExpressionTree> COMPILATION_HELPER_DO_TEST = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.CompilationTestHelper").named("doTest");
        private static final Matcher<ExpressionTree> TEST_HELPER_NEW_INSTANCE = MethodMatchers.staticMethod().onDescendantOfAny(new String[]{"com.google.errorprone.CompilationTestHelper", "com.google.errorprone.BugCheckerRefactoringTestHelper"}).named("newInstance").withParameters(Class.class.getCanonicalName(), new String[]{Class.class.getCanonicalName()});
        private static final Matcher<ExpressionTree> IDENTIFICATION_SOURCE_LINES = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.CompilationTestHelper").named("addSourceLines");
        private static final Matcher<ExpressionTree> REPLACEMENT_DO_TEST = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper").named("doTest");
        private static final Matcher<ExpressionTree> REPLACEMENT_EXPECT_UNCHANGED = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput").named("expectUnchanged");
        private static final Matcher<ExpressionTree> REPLACEMENT_OUTPUT_SOURCE_LINES = Matchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput").namedAnyOf(new String[]{"addOutputLines", "expectUnchanged"});
        private final List<TestCase> collectedTestCases = new ArrayList<TestCase>();

        private BugPatternTestCollector() {
        }

        private ImmutableList<TestCase> getCollectedTests() {
            return ImmutableList.copyOf(this.collectedTestCases);
        }

        @Override
        public @Nullable Void visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            boolean isReplacementTest = REPLACEMENT_DO_TEST.matches((Tree)node, state);
            if (isReplacementTest || COMPILATION_HELPER_DO_TEST.matches((Tree)node, state)) {
                BugPatternTestCollector.getClassUnderTest(node, state).ifPresent(classUnderTest -> {
                    ArrayList<TestEntry> entries = new ArrayList<TestEntry>();
                    if (isReplacementTest) {
                        BugPatternTestCollector.extractReplacementTestCases(node, entries, state);
                    } else {
                        BugPatternTestCollector.extractIdentificationTestCases(node, entries, state);
                    }
                    if (!entries.isEmpty()) {
                        this.collectedTestCases.add(new AutoValue_BugPatternTestExtractor_TestCase((String)classUnderTest, (ImmutableList<TestEntry>)ImmutableList.copyOf(entries).reverse()));
                    }
                });
            }
            return (Void)super.visitMethodInvocation(node, state);
        }

        private static Optional<String> getClassUnderTest(MethodInvocationTree tree, VisitorState state) {
            Optional<String> optional;
            if (TEST_HELPER_NEW_INSTANCE.matches((Tree)tree, state)) {
                return Optional.ofNullable(ASTHelpers.getSymbol((Tree)tree.getArguments().get(0))).filter(s -> !s.type.allparams().isEmpty()).map(s -> s.type.allparams().get((int)0).tsym.getQualifiedName().toString());
            }
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            if (receiver instanceof MethodInvocationTree) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)receiver;
                optional = BugPatternTestCollector.getClassUnderTest(methodInvocation, state);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        private static void extractIdentificationTestCases(MethodInvocationTree tree, List<TestEntry> sink, VisitorState state) {
            ExpressionTree receiver;
            if (IDENTIFICATION_SOURCE_LINES.matches((Tree)tree, state)) {
                String path = (String)ASTHelpers.constValue((Tree)tree.getArguments().get(0), String.class);
                Optional<String> sourceCode = BugPatternTestCollector.getSourceCode(tree).filter(s -> s.contains("// BUG: Diagnostic"));
                if (path != null && sourceCode.isPresent()) {
                    sink.add(new AutoValue_BugPatternTestExtractor_IdentificationTestEntry(path, sourceCode.orElseThrow()));
                }
            }
            if ((receiver = ASTHelpers.getReceiver((ExpressionTree)tree)) instanceof MethodInvocationTree) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)receiver;
                BugPatternTestCollector.extractIdentificationTestCases(methodInvocation, sink, state);
            }
        }

        private static void extractReplacementTestCases(MethodInvocationTree tree, List<TestEntry> sink, VisitorState state) {
            ExpressionTree receiver;
            if (REPLACEMENT_OUTPUT_SOURCE_LINES.matches((Tree)tree, state)) {
                MethodInvocationTree inputTree = (MethodInvocationTree)ASTHelpers.getReceiver((ExpressionTree)tree);
                String path = (String)ASTHelpers.constValue((Tree)inputTree.getArguments().get(0), String.class);
                Optional<String> inputCode = BugPatternTestCollector.getSourceCode(inputTree);
                if (path != null && inputCode.isPresent()) {
                    Optional<String> outputCode;
                    Optional<String> optional = outputCode = REPLACEMENT_EXPECT_UNCHANGED.matches((Tree)tree, state) ? inputCode : BugPatternTestCollector.getSourceCode(tree);
                    if (outputCode.isPresent() && !inputCode.equals(outputCode)) {
                        sink.add(new AutoValue_BugPatternTestExtractor_ReplacementTestEntry(path, inputCode.orElseThrow(), outputCode.orElseThrow()));
                    }
                }
            }
            if ((receiver = ASTHelpers.getReceiver((ExpressionTree)tree)) instanceof MethodInvocationTree) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)receiver;
                BugPatternTestCollector.extractReplacementTestCases(methodInvocation, sink, state);
            }
        }

        private static Optional<String> getSourceCode(MethodInvocationTree tree) {
            List<? extends ExpressionTree> sourceLines = tree.getArguments().subList(1, tree.getArguments().size());
            StringBuilder source = new StringBuilder();
            for (ExpressionTree expressionTree : sourceLines) {
                String value = (String)ASTHelpers.constValue((Tree)expressionTree, String.class);
                if (value == null) {
                    return Optional.empty();
                }
                source.append(value).append('\n');
            }
            return Optional.of(source.toString());
        }
    }

    @AutoValue
    static abstract class ReplacementTestEntry
    implements TestEntry {
        ReplacementTestEntry() {
        }

        static ReplacementTestEntry create(String path, String input, String output) {
            return new AutoValue_BugPatternTestExtractor_ReplacementTestEntry(path, input, output);
        }

        @Override
        @JsonProperty
        public final TestEntry.TestType type() {
            return TestEntry.TestType.REPLACEMENT;
        }

        abstract String input();

        abstract String output();
    }

    @AutoValue
    static abstract class IdentificationTestEntry
    implements TestEntry {
        IdentificationTestEntry() {
        }

        static IdentificationTestEntry create(String path, String code) {
            return new AutoValue_BugPatternTestExtractor_IdentificationTestEntry(path, code);
        }

        @Override
        @JsonProperty
        public final TestEntry.TestType type() {
            return TestEntry.TestType.IDENTIFICATION;
        }

        abstract String code();
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=AutoValue_BugPatternTestExtractor_IdentificationTestEntry.class), @JsonSubTypes.Type(value=AutoValue_BugPatternTestExtractor_ReplacementTestEntry.class)})
    @JsonTypeInfo(include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", use=JsonTypeInfo.Id.DEDUCTION)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(value={"type"})
    static interface TestEntry {
        public TestType type();

        public String path();

        public static enum TestType {
            IDENTIFICATION,
            REPLACEMENT;

        }
    }

    @JsonDeserialize(as=AutoValue_BugPatternTestExtractor_TestCase.class)
    @AutoValue
    static abstract class TestCase {
        TestCase() {
        }

        static TestCase create(String classUnderTest, ImmutableList<TestEntry> entries) {
            return new AutoValue_BugPatternTestExtractor_TestCase(classUnderTest, entries);
        }

        abstract String classUnderTest();

        abstract ImmutableList<TestEntry> entries();
    }

    @JsonDeserialize(as=AutoValue_BugPatternTestExtractor_TestCases.class)
    @AutoValue
    static abstract class TestCases {
        TestCases() {
        }

        static TestCases create(URI source, String testClass, ImmutableList<TestCase> testCases) {
            return new AutoValue_BugPatternTestExtractor_TestCases(source, testClass, testCases);
        }

        abstract URI source();

        abstract String testClass();

        abstract ImmutableList<TestCase> testCases();
    }
}

