/*
 * Decompiled with CFR 0.152.
 */
package tech.orla.utils;

import tech.orla.utils.OS;
import tech.orla.utils.OsDetectionException;

public class OSDetector {
    public static OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.WINDOWS;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return OS.UNIX;
        }
        if ("Mac OS X".equalsIgnoreCase(osName)) {
            return OS.MAC_OSX;
        }
        throw new OsDetectionException("Unrecognized OS: " + osName);
    }
}

