/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap.metric;

import tagbio.umap.metric.Metric;

public class WeightedMinkowskiMetric
extends Metric {
    private final double mPower;
    private final float[] mWeights;

    public WeightedMinkowskiMetric(double power, float[] weights) {
        super(false);
        this.mPower = power;
        this.mWeights = weights;
    }

    @Override
    public float distance(float[] x, float[] y) {
        float result = 0.0f;
        for (int i = 0; i < x.length; ++i) {
            result = (float)((double)result + Math.pow(this.mWeights[i] * Math.abs(x[i] - y[i]), this.mPower));
        }
        return (float)Math.pow(result, 1.0 / this.mPower);
    }
}

