/*
 * Decompiled with CFR 0.152.
 */
package tech.liujin.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import tech.liujin.widget.ScaleImageView;
import tech.liujin.widget.pager.BaseTypePagerAdapter;

public class ScaleImagePager
extends ViewPager {
    private int mState = 0;
    private boolean isScaleHandled;
    private MotionEvent mLastMotionEvent;
    private float mDownX;
    private float mDownY;
    private float mLastX;
    private float mLastY;
    private float mDx;
    private float mDy;
    private long mLastUpEventTime = 0L;
    private int mDownIdleScrollX;
    private Scroller mScroller;
    private VelocityTracker mTracker;
    private ScaleItemFling mFling;

    public ScaleImagePager(@NonNull Context context) {
        this(context, null);
    }

    public ScaleImagePager(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.addOnPageChangeListener(new ScrollSateListener());
        this.mScroller = new Scroller(this.getContext());
        this.mFling = new ScaleItemFling();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mScroller.forceFinished(true);
        }
        if (ev.getAction() == 0 && this.mState == 0) {
            this.mDownIdleScrollX = this.getScrollX();
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        BaseImageAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return super.onTouchEvent(ev);
        }
        int currentItem = this.getCurrentItem();
        int viewType = adapter.getViewType(currentItem);
        if (viewType == 0) {
            ScaleImageView view = adapter.getScaleImageViewAt(currentItem);
            if (ev.getPointerCount() > 1) {
                view.handleScaleGesture(ev);
                this.isScaleHandled = true;
                return true;
            }
            switch (ev.getAction()) {
                case 0: {
                    this.mDownX = this.mLastX = ev.getX();
                    this.mDownY = this.mLastY = ev.getY();
                    this.mLastMotionEvent = MotionEvent.obtain((MotionEvent)ev);
                    if (this.mTracker == null) {
                        this.mTracker = VelocityTracker.obtain();
                    }
                    this.mTracker.addMovement(ev);
                    break;
                }
                case 2: {
                    int scrollX;
                    if (this.isScaleHandled) {
                        MotionEvent event = this.createMoveMotionEvent(this.mLastMotionEvent, 0.0f, 0.0f, ev);
                        this.mLastMotionEvent.recycle();
                        this.mLastMotionEvent = MotionEvent.obtain((MotionEvent)event);
                        if (this.mTracker != null) {
                            this.mTracker.recycle();
                            this.mTracker = null;
                        }
                        return super.onTouchEvent(event);
                    }
                    float x = ev.getX();
                    float y = ev.getY();
                    this.mDx = x - this.mLastX;
                    this.mDy = y - this.mLastY;
                    this.mLastX = x;
                    this.mLastY = y;
                    if (this.mTracker != null) {
                        this.mTracker.addMovement(ev);
                    }
                    if ((scrollX = this.getScrollX()) > this.mDownIdleScrollX && this.mDx > 0.0f) {
                        int offset = this.mDownIdleScrollX - scrollX;
                        float dx = this.mDx;
                        if ((float)offset + dx > 0.0f) {
                            dx = -offset;
                        }
                        MotionEvent event = this.createMoveMotionEvent(this.mLastMotionEvent, dx, this.mDy, ev);
                        this.mLastMotionEvent.recycle();
                        this.mLastMotionEvent = MotionEvent.obtain((MotionEvent)event);
                        return super.onTouchEvent(event);
                    }
                    if (scrollX < this.mDownIdleScrollX && this.mDx < 0.0f) {
                        int offset = this.mDownIdleScrollX - scrollX;
                        float dx = this.mDx;
                        if (this.mDx + (float)offset < 0.0f) {
                            dx = -offset;
                        }
                        MotionEvent event = this.createMoveMotionEvent(this.mLastMotionEvent, dx, this.mDy, ev);
                        this.mLastMotionEvent.recycle();
                        this.mLastMotionEvent = MotionEvent.obtain((MotionEvent)event);
                        return super.onTouchEvent(event);
                    }
                    float movedX = this.scaleItemMovedX(view);
                    float movedY = this.scaleItemMovedY(view);
                    float dx = this.mDx - movedX;
                    float dy = this.mDy - movedY;
                    MotionEvent event = this.createMoveMotionEvent(this.mLastMotionEvent, dx, dy, ev);
                    this.mLastMotionEvent.recycle();
                    this.mLastMotionEvent = MotionEvent.obtain((MotionEvent)event);
                    return super.onTouchEvent(event);
                }
                case 1: {
                    if (this.isDoubleTap()) {
                        view.reset();
                    }
                    this.mDy = 0.0f;
                    this.mDx = 0.0f;
                    this.mLastY = 0.0f;
                    this.mLastX = 0.0f;
                    this.mDownY = 0.0f;
                    this.mDownX = 0.0f;
                    if (this.isScaleHandled) {
                        this.isScaleHandled = false;
                        if (this.mTracker != null) {
                            this.mTracker.recycle();
                            this.mTracker = null;
                        }
                    } else if (this.mTracker != null) {
                        this.mTracker.computeCurrentVelocity(256);
                        float xVelocity = this.mTracker.getXVelocity();
                        float yVelocity = this.mTracker.getYVelocity();
                        this.mTracker.recycle();
                        this.mTracker = null;
                        this.mFling.startFling(view, xVelocity, yVelocity);
                    }
                    MotionEvent upMotionEvent = this.createUpMotionEvent(this.mLastMotionEvent, ev);
                    this.mLastMotionEvent.recycle();
                    this.mLastMotionEvent = null;
                    return super.onTouchEvent(upMotionEvent);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    private MotionEvent createUpMotionEvent(MotionEvent lastMotionEvent, MotionEvent upEvent) {
        return MotionEvent.obtain((long)lastMotionEvent.getDownTime(), (long)upEvent.getEventTime(), (int)upEvent.getAction(), (float)lastMotionEvent.getX(), (float)lastMotionEvent.getY(), (int)upEvent.getMetaState());
    }

    private MotionEvent createMoveMotionEvent(MotionEvent lastMotionEvent, float dx, float dy, MotionEvent currentMotionEvent) {
        return MotionEvent.obtain((long)lastMotionEvent.getDownTime(), (long)currentMotionEvent.getEventTime(), (int)currentMotionEvent.getAction(), (float)(lastMotionEvent.getX() + dx), (float)(lastMotionEvent.getY() + dy), (int)currentMotionEvent.getMetaState());
    }

    private float scaleItemMovedX(ScaleImageView imageView) {
        RectF rect = imageView.getDrawableRect();
        if (rect.left < 0.0f && this.mDx > 0.0f) {
            float dx = this.mDx;
            if (rect.left + this.mDx > 0.0f) {
                dx = -rect.left;
            }
            imageView.setTranslateX(imageView.getTranslateX() + dx);
            return dx;
        }
        int width = imageView.getWidth();
        if (rect.right > (float)width && this.mDx < 0.0f) {
            float dx = this.mDx;
            if (rect.right + this.mDx < (float)width) {
                dx = (float)width - rect.right;
            }
            imageView.setTranslateX(imageView.getTranslateX() + dx);
            return dx;
        }
        return 0.0f;
    }

    private float scaleItemMovedY(ScaleImageView imageView) {
        RectF rect = imageView.getDrawableRect();
        if (rect.top < 0.0f && this.mDy > 0.0f) {
            float dy = this.mDy;
            if (rect.top + this.mDy > 0.0f) {
                dy = -rect.top;
            }
            imageView.setTranslateY(imageView.getTranslateY() + dy);
            return dy;
        }
        int height = imageView.getHeight();
        if (rect.bottom > (float)height && this.mDy < 0.0f) {
            float dy = this.mDy;
            if (rect.bottom + this.mDy < (float)height) {
                dy = (float)height - rect.bottom;
            }
            imageView.setTranslateY(imageView.getTranslateY() + dy);
            return dy;
        }
        return 0.0f;
    }

    private boolean isDoubleTap() {
        long currentTime = System.currentTimeMillis();
        int i = 256;
        if (currentTime - this.mLastUpEventTime < 256L) {
            return true;
        }
        this.mLastUpEventTime = currentTime;
        return false;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mFling.computeScrollOffset()) {
            this.mFling.setScaleTranslate();
            this.invalidate();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
    }

    public void setAdapter(@Nullable BaseImageAdapter adapter) {
        super.setAdapter((PagerAdapter)adapter);
    }

    @Nullable
    public BaseImageAdapter getAdapter() {
        return (BaseImageAdapter)super.getAdapter();
    }

    private class ScaleItemFling {
        private int mXVelocity;
        private int mYVelocity;
        private ScaleImageView mScaleImageView;
        private float mTranslateX;
        private float mTranslateY;

        private ScaleItemFling() {
        }

        private void startFling(ScaleImageView imageView, float xVelocity, float yVelocity) {
            this.mXVelocity = (int)xVelocity;
            this.mYVelocity = (int)yVelocity;
            this.mScaleImageView = imageView;
            RectF rect = this.mScaleImageView.getDrawableRect();
            int width = this.mScaleImageView.getWidth();
            int height = this.mScaleImageView.getHeight();
            this.mTranslateX = this.mScaleImageView.getTranslateX();
            this.mTranslateY = this.mScaleImageView.getTranslateY();
            int minX = 0;
            if (xVelocity < 0.0f && rect.right > (float)width) {
                minX = (int)((float)width - rect.right);
            }
            int maxX = 0;
            if (xVelocity > 0.0f && rect.left < 0.0f) {
                maxX = (int)(-rect.left);
            }
            int minY = 0;
            if (yVelocity < 0.0f && rect.bottom > (float)height) {
                minY = (int)((float)height - rect.bottom);
            }
            int maxY = 0;
            if (yVelocity > 0.0f && rect.top < 0.0f) {
                maxY = (int)(-rect.top);
            }
            ScaleImagePager.this.mScroller.fling(0, 0, this.mXVelocity, this.mYVelocity, minX / 2, maxX / 2, minY / 2, maxY / 2);
            ScaleImagePager.this.invalidate();
        }

        private boolean computeScrollOffset() {
            return ScaleImagePager.this.mScroller.computeScrollOffset();
        }

        private int getCurrX() {
            return ScaleImagePager.this.mScroller.getCurrX();
        }

        private int getCurrY() {
            return ScaleImagePager.this.mScroller.getCurrY();
        }

        private void setScaleTranslate() {
            int currX = ScaleImagePager.this.mScroller.getCurrX();
            int currY = ScaleImagePager.this.mScroller.getCurrY();
            this.mScaleImageView.setTranslate(this.mTranslateX + (float)(currX * 2), this.mTranslateY + (float)(currY * 2));
        }
    }

    private class ScrollSateListener
    implements ViewPager.OnPageChangeListener {
        private ScrollSateListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
            ScaleImagePager.this.mState = state;
        }
    }

    public static abstract class SimpleImageAdapter
    extends BaseImageAdapter {
        @Override
        protected ScaleImageView getScaleImageViewAt(int position) {
            return (ScaleImageView)this.getItemView(position);
        }

        @Override
        protected Object getData(int position, int type) {
            return this.getBitmapAt(position);
        }

        protected abstract Bitmap getBitmapAt(int var1);

        @Override
        protected View getView(ViewGroup container, int position, int type) {
            ScaleImageView scaleImageView = new ScaleImageView(container.getContext());
            scaleImageView.setTouchEventEnabled(false);
            return scaleImageView;
        }

        @Override
        protected void bindData(int position, Object data, View view, int type) {
            ((ScaleImageView)view).setImageBitmap((Bitmap)data);
        }
    }

    public static abstract class BaseImageAdapter
    extends BaseTypePagerAdapter {
        public static final int TYPE_SCALE_IMAGE = 0;

        @Override
        protected int getViewType(int position) {
            return 0;
        }

        protected abstract ScaleImageView getScaleImageViewAt(int var1);

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            if (this.getViewType(position) == 0) {
                this.getScaleImageViewAt(position).reset();
            }
            super.destroyItem(container, position, object);
        }
    }
}

