/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.handshake;

import java.nio.ByteBuffer;
import java.util.List;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.TlsProtocolException;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.alert.IllegalParameterAlert;
import tech.kwik.agent15.extension.EarlyDataExtension;
import tech.kwik.agent15.extension.Extension;
import tech.kwik.agent15.extension.UnknownExtension;
import tech.kwik.agent15.handshake.EncryptedExtensions;
import tech.kwik.agent15.handshake.HandshakeMessage;

public class NewSessionTicketMessage
extends HandshakeMessage {
    private static final int MINIMUM_MESSAGE_SIZE = 17;
    private long ticketAgeAdd;
    private byte[] ticket;
    private byte[] ticketNonce;
    private int ticketLifetime;
    private EarlyDataExtension earlyDataExtension;

    public NewSessionTicketMessage() {
    }

    public NewSessionTicketMessage(int ticketLifetime, long ticketAgeAdd, byte[] ticketNonce, byte[] ticket) {
        this.ticketAgeAdd = ticketAgeAdd;
        this.ticket = ticket;
        this.ticketNonce = ticketNonce;
        this.ticketLifetime = ticketLifetime;
    }

    public NewSessionTicketMessage(int ticketLifetime, long ticketAgeAdd, byte[] ticketNonce, byte[] ticket, long maxEarlyDataSize) {
        this.ticketAgeAdd = ticketAgeAdd;
        this.ticket = ticket;
        this.ticketNonce = ticketNonce;
        this.ticketLifetime = ticketLifetime;
        this.earlyDataExtension = new EarlyDataExtension(maxEarlyDataSize);
    }

    public NewSessionTicketMessage parse(ByteBuffer buffer) throws TlsProtocolException {
        int remainingLength = this.parseHandshakeHeader(buffer, TlsConstants.HandshakeType.new_session_ticket, 17);
        this.ticketLifetime = buffer.getInt();
        remainingLength -= 4;
        if (this.ticketLifetime > 604800 || this.ticketLifetime < 0) {
            throw new IllegalParameterAlert("Invalid ticket lifetime");
        }
        this.ticketAgeAdd = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.ticketNonce = this.parseByteVector(buffer, 1, remainingLength -= 4, "ticket nonce");
        this.ticket = this.parseByteVector(buffer, 2, remainingLength -= 1 + this.ticketNonce.length, "ticket");
        List<Extension> extensions = EncryptedExtensions.parseExtensions(buffer, TlsConstants.HandshakeType.new_session_ticket);
        for (Extension extension : extensions) {
            if (extension instanceof EarlyDataExtension) {
                if (this.earlyDataExtension == null) {
                    this.earlyDataExtension = (EarlyDataExtension)extension;
                    continue;
                }
                throw new DecodeErrorException("repeated extension is not allowed");
            }
            if (!(extension instanceof UnknownExtension)) continue;
        }
        return this;
    }

    private byte[] parseByteVector(ByteBuffer buffer, int lengthBytes, int remainingMessageLength, String fieldName) throws DecodeErrorException {
        if (remainingMessageLength < lengthBytes) {
            throw new DecodeErrorException("No length specified for " + fieldName);
        }
        int vectorSize = 0;
        for (int i = 0; i < lengthBytes; ++i) {
            vectorSize = vectorSize << 8 | buffer.get() & 0xFF;
        }
        if ((remainingMessageLength -= lengthBytes) < vectorSize) {
            throw new DecodeErrorException("Message too short for given length of " + fieldName);
        }
        byte[] byteVector = new byte[vectorSize];
        buffer.get(byteVector);
        return byteVector;
    }

    @Override
    public TlsConstants.HandshakeType getType() {
        return TlsConstants.HandshakeType.new_session_ticket;
    }

    @Override
    public byte[] getBytes() {
        int extensionLength = this.earlyDataExtension != null ? this.earlyDataExtension.getBytes().length : 0;
        int dataLength = 9 + this.ticketNonce.length + 2 + this.ticket.length + 2 + extensionLength;
        ByteBuffer buffer = ByteBuffer.allocate(4 + dataLength);
        buffer.putInt(TlsConstants.HandshakeType.new_session_ticket.value << 24 | dataLength);
        buffer.putInt(this.ticketLifetime);
        buffer.putInt((int)this.ticketAgeAdd);
        buffer.put((byte)this.ticketNonce.length);
        buffer.put(this.ticketNonce);
        buffer.putShort((short)this.ticket.length);
        buffer.put(this.ticket);
        buffer.putShort((short)extensionLength);
        if (this.earlyDataExtension != null) {
            buffer.put(this.earlyDataExtension.getBytes());
        }
        return buffer.array();
    }

    public int getTicketLifetime() {
        return this.ticketLifetime;
    }

    public long getTicketAgeAdd() {
        return this.ticketAgeAdd;
    }

    public byte[] getTicket() {
        return this.ticket;
    }

    public byte[] getTicketNonce() {
        return this.ticketNonce;
    }

    public EarlyDataExtension getEarlyDataExtension() {
        return this.earlyDataExtension;
    }
}

