/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.extension;

import java.nio.ByteBuffer;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.TlsProtocolException;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.extension.Extension;

public class SupportedVersionsExtension
extends Extension {
    private final TlsConstants.HandshakeType handshakeType;
    private short tlsVersion;

    public SupportedVersionsExtension(TlsConstants.HandshakeType handshakeType) {
        this.handshakeType = handshakeType;
        this.tlsVersion = (short)772;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SupportedVersionsExtension(ByteBuffer buffer, TlsConstants.HandshakeType handshakeType) throws TlsProtocolException {
        this.handshakeType = handshakeType;
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.supported_versions, 2);
        if (handshakeType == TlsConstants.HandshakeType.client_hello) {
            int versionsLength = buffer.get() & 0xFF;
            if (versionsLength % 2 != 0 || extensionDataLength != versionsLength + 1) throw new DecodeErrorException("invalid versions length");
            for (int i = 0; i < versionsLength; i += 2) {
                short version = buffer.getShort();
                if (version != 772 && this.tlsVersion != 0) continue;
                this.tlsVersion = version;
            }
            return;
        } else {
            if (handshakeType != TlsConstants.HandshakeType.server_hello) throw new IllegalArgumentException();
            if (extensionDataLength != 2) {
                throw new DecodeErrorException("Incorrect extension length");
            }
            this.tlsVersion = buffer.getShort();
        }
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.handshakeType.equals((Object)TlsConstants.HandshakeType.client_hello) ? 7 : 6);
        buffer.putShort(TlsConstants.ExtensionType.supported_versions.value);
        if (this.handshakeType.equals((Object)TlsConstants.HandshakeType.client_hello)) {
            buffer.putShort((short)3);
            buffer.put((byte)2);
            buffer.put(new byte[]{3, 4});
        } else {
            buffer.putShort((short)2);
            buffer.put(new byte[]{3, 4});
        }
        return buffer.array();
    }

    public short getTlsVersion() {
        return this.tlsVersion;
    }
}

