/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.extension;

import java.nio.ByteBuffer;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.extension.Extension;

public class EarlyDataExtension
extends Extension {
    private Long maxEarlyDataSize;

    public EarlyDataExtension() {
    }

    public EarlyDataExtension(long maxEarlyDataSize) {
        this.maxEarlyDataSize = maxEarlyDataSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EarlyDataExtension(ByteBuffer buffer, TlsConstants.HandshakeType context) throws DecodeErrorException {
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.early_data.value, 0);
        if (context == TlsConstants.HandshakeType.new_session_ticket) {
            if (extensionDataLength != 4) throw new DecodeErrorException("invalid extension data length");
            this.maxEarlyDataSize = (long)buffer.getInt() & 0xFFFFFFFFL;
            return;
        } else {
            if (extensionDataLength == 0) return;
            throw new DecodeErrorException("invalid extension data length");
        }
    }

    @Override
    public byte[] getBytes() {
        int extensionDataLength = this.maxEarlyDataSize == null ? 0 : 4;
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionDataLength);
        buffer.putShort(TlsConstants.ExtensionType.early_data.value);
        buffer.putShort((short)extensionDataLength);
        if (this.maxEarlyDataSize != null) {
            buffer.putInt((int)this.maxEarlyDataSize.longValue());
        }
        return buffer.array();
    }

    public long getMaxEarlyDataSize() {
        return this.maxEarlyDataSize;
    }

    public String toString() {
        return "EarlyDataExtension " + (String)(this.maxEarlyDataSize == null ? "(empty)" : "[" + this.maxEarlyDataSize + "]");
    }
}

