/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.engine;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import tech.kwik.agent15.NewSessionTicket;
import tech.kwik.agent15.ProtectionKeysType;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.TlsProtocolException;
import tech.kwik.agent15.alert.ErrorAlert;
import tech.kwik.agent15.alert.IllegalParameterAlert;
import tech.kwik.agent15.alert.MissingExtensionAlert;
import tech.kwik.agent15.alert.UnexpectedMessageAlert;
import tech.kwik.agent15.engine.CertificateWithPrivateKey;
import tech.kwik.agent15.engine.HostnameVerifier;
import tech.kwik.agent15.engine.TlsEngine;
import tech.kwik.agent15.extension.Extension;
import tech.kwik.agent15.handshake.CertificateMessage;
import tech.kwik.agent15.handshake.CertificateRequestMessage;
import tech.kwik.agent15.handshake.CertificateVerifyMessage;
import tech.kwik.agent15.handshake.EncryptedExtensions;
import tech.kwik.agent15.handshake.FinishedMessage;
import tech.kwik.agent15.handshake.NewSessionTicketMessage;
import tech.kwik.agent15.handshake.ServerHello;

public interface TlsClientEngine
extends TlsEngine {
    public void setServerName(String var1);

    public void addSupportedCiphers(List<TlsConstants.CipherSuite> var1);

    public void add(Extension var1);

    public void addExtensions(List<Extension> var1);

    public void setTrustManager(X509TrustManager var1);

    public void setHostnameVerifier(HostnameVerifier var1);

    public void setNewSessionTicket(NewSessionTicket var1);

    public void setClientCertificateCallback(Function<List<X500Principal>, CertificateWithPrivateKey> var1);

    public void startHandshake() throws IOException;

    public void startHandshake(TlsConstants.NamedGroup var1) throws IOException;

    public void startHandshake(TlsConstants.NamedGroup var1, List<TlsConstants.SignatureScheme> var2) throws IOException;

    public boolean handshakeFinished();

    public TlsConstants.CipherSuite getSelectedCipher();

    public List<NewSessionTicket> getNewSessionTickets();

    public List<X509Certificate> getServerCertificateChain();

    public void setCompatibilityMode(boolean var1);

    @Override
    public void received(ServerHello var1, ProtectionKeysType var2) throws MissingExtensionAlert, IllegalParameterAlert;

    @Override
    public void received(EncryptedExtensions var1, ProtectionKeysType var2) throws TlsProtocolException;

    @Override
    public void received(CertificateMessage var1, ProtectionKeysType var2) throws TlsProtocolException;

    @Override
    public void received(CertificateVerifyMessage var1, ProtectionKeysType var2) throws TlsProtocolException;

    @Override
    public void received(FinishedMessage var1, ProtectionKeysType var2) throws ErrorAlert, IOException;

    @Override
    public void received(NewSessionTicketMessage var1, ProtectionKeysType var2) throws UnexpectedMessageAlert;

    @Override
    public void received(CertificateRequestMessage var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;
}

