/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.handshake;

import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.luminis.tls.BinderCalculator;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.alert.IllegalParameterAlert;
import net.luminis.tls.extension.ClientHelloPreSharedKeyExtension;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.extension.ExtensionParser;
import net.luminis.tls.extension.KeyShareExtension;
import net.luminis.tls.extension.PreSharedKeyExtension;
import net.luminis.tls.extension.PskKeyExchangeModesExtension;
import net.luminis.tls.extension.ServerNameExtension;
import net.luminis.tls.extension.SignatureAlgorithmsExtension;
import net.luminis.tls.extension.SupportedGroupsExtension;
import net.luminis.tls.extension.SupportedVersionsExtension;
import net.luminis.tls.handshake.HandshakeMessage;

public class ClientHello
extends HandshakeMessage {
    private static final int MAX_CLIENT_HELLO_SIZE = 3000;
    public static final List<TlsConstants.CipherSuite> SUPPORTED_CIPHERS = List.of(TlsConstants.CipherSuite.TLS_AES_128_GCM_SHA256);
    private static final int MINIMAL_MESSAGE_LENGTH = 47;
    private static final List<TlsConstants.SignatureScheme> SUPPORTED_SIGNATURES = List.of(TlsConstants.SignatureScheme.rsa_pss_rsae_sha256);
    private static Random random = new Random();
    private static SecureRandom secureRandom = new SecureRandom();
    private final byte[] data;
    private final int pskExtensionStartPosition;
    private byte[] clientRandom;
    private List<TlsConstants.CipherSuite> cipherSuites = new ArrayList<TlsConstants.CipherSuite>();
    private List<Extension> extensions;

    public ClientHello(ByteBuffer buffer, ExtensionParser customExtensionParser) throws TlsProtocolException, IllegalParameterAlert {
        int startPosition = buffer.position();
        if (buffer.remaining() < 4) {
            throw new DecodeErrorException("message underflow");
        }
        if (buffer.remaining() < 47) {
            throw new DecodeErrorException("message underflow");
        }
        byte messageType = buffer.get();
        if (messageType != TlsConstants.HandshakeType.client_hello.value) {
            throw new RuntimeException();
        }
        int length = (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
        if (buffer.remaining() < length) {
            throw new DecodeErrorException("message underflow");
        }
        short legacyVersion = buffer.getShort();
        if (legacyVersion != 771) {
            throw new DecodeErrorException("legacy version must be 0303");
        }
        this.clientRandom = new byte[32];
        buffer.get(this.clientRandom);
        byte sessionIdLength = buffer.get();
        if (sessionIdLength > 0) {
            buffer.get(new byte[sessionIdLength]);
        }
        int cipherSuitesLength = buffer.getShort();
        for (int i = 0; i < cipherSuitesLength; i += 2) {
            short cipherSuiteValue = buffer.getShort();
            Arrays.stream(TlsConstants.CipherSuite.values()).filter(item -> item.value == cipherSuiteValue).findFirst().ifPresent(item -> this.cipherSuites.add((TlsConstants.CipherSuite)((Object)item)));
        }
        byte legacyCompressionMethodsLength = buffer.get();
        byte legacyCompressionMethod = buffer.get();
        if (legacyCompressionMethodsLength != 1 || legacyCompressionMethod != 0) {
            throw new IllegalParameterAlert("Invalid legacy compression method");
        }
        int extensionStart = buffer.position();
        this.extensions = ClientHello.parseExtensions(buffer, TlsConstants.HandshakeType.client_hello, customExtensionParser);
        if (this.extensions.stream().anyMatch(ext -> ext instanceof PreSharedKeyExtension)) {
            buffer.position(extensionStart);
            this.pskExtensionStartPosition = ClientHello.findPositionLastExtension(buffer);
            if (!(this.extensions.get(this.extensions.size() - 1) instanceof PreSharedKeyExtension)) {
                throw new IllegalParameterAlert("pre_shared_key extension MUST be the last extension in the ClientHello");
            }
        } else {
            this.pskExtensionStartPosition = -1;
        }
        this.data = new byte[buffer.position() - startPosition];
        buffer.position(startPosition);
        buffer.get(this.data);
    }

    public ClientHello(String serverName, ECPublicKey publicKey) {
        this(serverName, publicKey, true, SUPPORTED_CIPHERS, SUPPORTED_SIGNATURES, TlsConstants.NamedGroup.secp256r1, Collections.emptyList(), null, PskKeyEstablishmentMode.both);
    }

    public ClientHello(String serverName, ECPublicKey publicKey, boolean compatibilityMode, List<Extension> extraExtensions) {
        this(serverName, publicKey, compatibilityMode, SUPPORTED_CIPHERS, SUPPORTED_SIGNATURES, TlsConstants.NamedGroup.secp256r1, extraExtensions, null, PskKeyEstablishmentMode.both);
    }

    public ClientHello(String serverName, PublicKey publicKey, boolean compatibilityMode, List<TlsConstants.CipherSuite> supportedCiphers, List<TlsConstants.SignatureScheme> supportedSignatures, TlsConstants.NamedGroup ecCurve, List<Extension> extraExtensions, BinderCalculator binderCalculator, PskKeyEstablishmentMode pskKeyEstablishmentMode) {
        byte[] sessionId;
        this.cipherSuites = supportedCiphers;
        ByteBuffer buffer = ByteBuffer.allocate(3000);
        buffer.put((byte)1);
        byte[] length = new byte[3];
        buffer.put(length);
        buffer.put((byte)3);
        buffer.put((byte)3);
        this.clientRandom = new byte[32];
        secureRandom.nextBytes(this.clientRandom);
        buffer.put(this.clientRandom);
        if (compatibilityMode) {
            sessionId = new byte[32];
            random.nextBytes(sessionId);
        } else {
            sessionId = new byte[]{};
        }
        buffer.put((byte)sessionId.length);
        if (sessionId.length > 0) {
            buffer.put(sessionId);
        }
        buffer.putShort((short)(supportedCiphers.size() * 2));
        for (TlsConstants.CipherSuite cipher : supportedCiphers) {
            buffer.putShort(cipher.value);
        }
        buffer.put(new byte[]{1, 0});
        Extension[] defaultExtensions = new Extension[]{new ServerNameExtension(serverName), new SupportedVersionsExtension(TlsConstants.HandshakeType.client_hello), new SupportedGroupsExtension(ecCurve), new SignatureAlgorithmsExtension(supportedSignatures), new KeyShareExtension(publicKey, ecCurve, TlsConstants.HandshakeType.client_hello)};
        this.extensions = new ArrayList<Extension>();
        this.extensions.addAll(List.of(defaultExtensions));
        if (pskKeyEstablishmentMode != PskKeyEstablishmentMode.none) {
            this.extensions.add(this.createPskKeyExchangeModesExtension(pskKeyEstablishmentMode));
        }
        this.extensions.addAll(extraExtensions);
        ClientHelloPreSharedKeyExtension pskExtension = null;
        int extensionsLength = this.extensions.stream().mapToInt(ext -> ext.getBytes().length).sum();
        buffer.putShort((short)extensionsLength);
        int pskExtensionStartPosition = -1;
        for (Extension extension : this.extensions) {
            if (extension instanceof ClientHelloPreSharedKeyExtension) {
                pskExtension = (ClientHelloPreSharedKeyExtension)extension;
                pskExtensionStartPosition = buffer.position();
            }
            buffer.put(extension.getBytes());
        }
        this.pskExtensionStartPosition = pskExtensionStartPosition;
        buffer.limit(buffer.position());
        int clientHelloLength = buffer.position() - 4;
        buffer.putShort(2, (short)clientHelloLength);
        this.data = new byte[clientHelloLength + 4];
        buffer.rewind();
        buffer.get(this.data);
        if (pskExtension != null) {
            if (binderCalculator == null) {
                throw new IllegalArgumentException("BinderCalculator cannot be null when ClientHelloPreSharedKeyExtension is present");
            }
            pskExtension.calculateBinder(this.data, pskExtensionStartPosition, binderCalculator);
            buffer.position(pskExtensionStartPosition);
            buffer.put(pskExtension.getBytes());
            buffer.rewind();
            buffer.get(this.data);
        }
    }

    private PskKeyExchangeModesExtension createPskKeyExchangeModesExtension(PskKeyEstablishmentMode pskKeyEstablishmentMode) {
        switch (pskKeyEstablishmentMode.ordinal()) {
            case 1: {
                return new PskKeyExchangeModesExtension(TlsConstants.PskKeyExchangeMode.psk_ke);
            }
            case 2: {
                return new PskKeyExchangeModesExtension(TlsConstants.PskKeyExchangeMode.psk_dhe_ke);
            }
            case 3: {
                return new PskKeyExchangeModesExtension(TlsConstants.PskKeyExchangeMode.psk_ke, TlsConstants.PskKeyExchangeMode.psk_dhe_ke);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public TlsConstants.HandshakeType getType() {
        return TlsConstants.HandshakeType.client_hello;
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    public byte[] getClientRandom() {
        return this.clientRandom;
    }

    public List<TlsConstants.CipherSuite> getCipherSuites() {
        return this.cipherSuites;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public int getPskExtensionStartPosition() {
        return this.pskExtensionStartPosition;
    }

    public String toString() {
        return "ClientHello[" + this.cipherSuites.stream().map(cs -> cs.toString()).collect(Collectors.joining(",")) + "|" + this.extensions.stream().map(ex -> ex.toString()).collect(Collectors.joining(",")) + "]";
    }

    public static enum PskKeyEstablishmentMode {
        none,
        PSKonly,
        PSKwithDHE,
        both;

    }
}

