/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.luminis.tls.NewSessionTicket;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsState;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.extension.PreSharedKeyExtension;
import net.luminis.tls.handshake.TlsEngine;

public class ClientHelloPreSharedKeyExtension
extends PreSharedKeyExtension {
    private static int MINIMUM_EXTENSION_DATA_SIZE = 44;
    private List<PskIdentity> identities;
    private List<PskBinderEntry> binders;
    private int binderPosition;
    private byte[] binder;

    public ClientHelloPreSharedKeyExtension(NewSessionTicket newSessionTicket) {
        Date ticketCreationDate = newSessionTicket.getTicketCreationDate();
        long ticketAgeAdd = newSessionTicket.getTicketAgeAdd();
        byte[] sessionTicketIdentity = newSessionTicket.getSessionTicketIdentity();
        long obfuscatedTicketAge = (new Date().getTime() - ticketCreationDate.getTime() + ticketAgeAdd) % 0x100000000L;
        this.identities = List.of(new PskIdentity(sessionTicketIdentity, obfuscatedTicketAge));
        this.binders = new ArrayList<PskBinderEntry>();
        this.binders.add(new PskBinderEntry(new byte[TlsEngine.hashLength(newSessionTicket.getCipher())]));
    }

    public ClientHelloPreSharedKeyExtension() {
    }

    public ClientHelloPreSharedKeyExtension parse(ByteBuffer buffer) throws DecodeErrorException {
        int bindersLength;
        int binderLength;
        int remainingIdentitiesLength;
        int identityLength;
        int startPosition = buffer.position();
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.pre_shared_key, MINIMUM_EXTENSION_DATA_SIZE);
        this.identities = new ArrayList<PskIdentity>();
        int remaining = extensionDataLength - 2;
        for (remainingIdentitiesLength = buffer.getShort() & 0xFFFF; remainingIdentitiesLength > 0; remainingIdentitiesLength -= 2 + identityLength + 4) {
            if (remaining < 2) {
                throw new DecodeErrorException("Incomplete psk identity");
            }
            identityLength = buffer.getShort() & 0xFFFF;
            if (identityLength > (remaining -= 2)) {
                throw new DecodeErrorException("Incorrect identity length value");
            }
            byte[] identity = new byte[identityLength];
            buffer.get(identity);
            if ((remaining -= identityLength) < 4) {
                throw new DecodeErrorException("Incomplete psk identity");
            }
            int obfuscatedTicketAge = buffer.getInt();
            remaining -= 4;
            this.identities.add(new PskIdentity(identity, obfuscatedTicketAge));
        }
        if (remainingIdentitiesLength != 0) {
            throw new DecodeErrorException("Incorrect identities length value");
        }
        this.binderPosition = buffer.position() - startPosition;
        this.binders = new ArrayList<PskBinderEntry>();
        if (remaining < 2) {
            throw new DecodeErrorException("Incomplete binders");
        }
        remaining -= 2;
        for (bindersLength = buffer.getShort() & 0xFFFF; bindersLength > 0; bindersLength -= 1 + binderLength) {
            if (remaining < 1) {
                throw new DecodeErrorException("Incorrect binder value");
            }
            binderLength = buffer.get() & 0xFF;
            if (binderLength > --remaining) {
                throw new DecodeErrorException("Incorrect binder length value");
            }
            if (binderLength < 32) {
                throw new DecodeErrorException("Invalid binder length");
            }
            byte[] hmac = new byte[binderLength];
            buffer.get(hmac);
            remaining -= binderLength;
            this.binders.add(new PskBinderEntry(hmac));
        }
        if (bindersLength != 0) {
            throw new DecodeErrorException("Incorrect binders length value");
        }
        if (remaining > 0) {
            throw new DecodeErrorException("Incorrect extension data length value");
        }
        if (this.identities.size() != this.binders.size()) {
            throw new DecodeErrorException("Inconsistent number of identities vs binders");
        }
        if (this.identities.size() == 0) {
            throw new DecodeErrorException("Empty OfferedPsks");
        }
        return this;
    }

    @Override
    public byte[] getBytes() {
        int identitiesSize = this.identities.stream().mapToInt(id -> 2 + id.identity.length + 4).sum();
        int bindersSize = this.binders.stream().mapToInt(b -> 1 + b.hmac.length).sum();
        int extensionDataLength = 2 + identitiesSize + 2 + bindersSize;
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionDataLength);
        buffer.putShort(TlsConstants.ExtensionType.pre_shared_key.value);
        buffer.putShort((short)extensionDataLength);
        buffer.putShort((short)identitiesSize);
        for (PskIdentity identity : this.identities) {
            buffer.putShort((short)identity.identity.length);
            buffer.put(identity.identity);
            buffer.putInt((int)identity.obfuscatedTicketAge);
        }
        this.binderPosition = buffer.position();
        buffer.putShort((short)bindersSize);
        for (PskBinderEntry binder : this.binders) {
            buffer.put((byte)binder.hmac.length);
            buffer.put(binder.hmac);
        }
        byte[] data = new byte[buffer.position()];
        buffer.flip();
        buffer.get(data);
        return data;
    }

    public void calculateBinder(byte[] clientHello, int pskExtensionStartPosition, TlsState tlsState) {
        int partialHelloSize = pskExtensionStartPosition + this.binderPosition;
        byte[] partialHello = new byte[partialHelloSize];
        ByteBuffer.wrap(clientHello).get(partialHello);
        this.binders.set(0, new PskBinderEntry(tlsState.computePskBinder(partialHello)));
    }

    public List<PskIdentity> getIdentities() {
        return this.identities;
    }

    public List<PskBinderEntry> getBinders() {
        return this.binders;
    }

    public int getBinderPosition() {
        return this.binderPosition;
    }

    public static class PskBinderEntry {
        byte[] hmac;

        public PskBinderEntry(byte[] hmac) {
            this.hmac = hmac;
        }

        public byte[] getHmac() {
            return this.hmac;
        }
    }

    public static class PskIdentity {
        byte[] identity;
        long obfuscatedTicketAge;

        public PskIdentity(byte[] sessionTicketIdentity, long obfuscatedTicketAge) {
            this.identity = sessionTicketIdentity;
            this.obfuscatedTicketAge = obfuscatedTicketAge;
        }

        public byte[] getIdentity() {
            return this.identity;
        }

        public long getObfuscatedTicketAge() {
            return this.obfuscatedTicketAge;
        }
    }
}

