/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.utils;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import tech.kronicle.sdk.models.Tag;
import tech.kronicle.utils.MapCollectors;

public class TagListComparator
implements Comparator<List<Tag>> {
    @Override
    public int compare(List<Tag> o1, List<Tag> o2) {
        Map<String, String> map1 = this.getMap(o1);
        Map<String, String> map2 = this.getMap(o2);
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(map1.keySet());
        allKeys.addAll(map2.keySet());
        List sortedAllKeys = allKeys.stream().sorted().collect(Collectors.toUnmodifiableList());
        for (String key : sortedAllKeys) {
            String value1 = map1.get(key);
            String value2 = map2.get(key);
            if (Objects.isNull(value1)) {
                return 1;
            }
            if (Objects.isNull(value2)) {
                return -1;
            }
            int result = value1.compareTo(value2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private Map<String, String> getMap(List<Tag> tags) {
        return tags.stream().map(tag -> Map.entry(tag.getKey(), tag.getValue())).collect(MapCollectors.toUnmodifiableMap());
    }
}

