/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.DependencyDirection;
import tech.kronicle.sdk.models.ObjectWithReference;

public final class ComponentDependency
implements ObjectWithReference {
    @NotBlank
    private final String targetComponentId;
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String typeId;
    private final DependencyDirection direction;
    private final String label;
    private final String description;

    @Override
    public String reference() {
        return this.targetComponentId + (String)(Objects.nonNull(this.typeId) ? " of type " + this.typeId : "");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ComponentDependencyBuilder builder() {
        return new ComponentDependencyBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentDependencyBuilder toBuilder() {
        return new ComponentDependencyBuilder().targetComponentId(this.targetComponentId).typeId(this.typeId).direction(this.direction).label(this.label).description(this.description);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTargetComponentId() {
        return this.targetComponentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTypeId() {
        return this.typeId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DependencyDirection getDirection() {
        return this.direction;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLabel() {
        return this.label;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentDependency)) {
            return false;
        }
        ComponentDependency other = (ComponentDependency)o;
        String this$targetComponentId = this.getTargetComponentId();
        String other$targetComponentId = other.getTargetComponentId();
        if (this$targetComponentId == null ? other$targetComponentId != null : !this$targetComponentId.equals(other$targetComponentId)) {
            return false;
        }
        String this$typeId = this.getTypeId();
        String other$typeId = other.getTypeId();
        if (this$typeId == null ? other$typeId != null : !this$typeId.equals(other$typeId)) {
            return false;
        }
        DependencyDirection this$direction = this.getDirection();
        DependencyDirection other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $targetComponentId = this.getTargetComponentId();
        result = result * 59 + ($targetComponentId == null ? 43 : $targetComponentId.hashCode());
        String $typeId = this.getTypeId();
        result = result * 59 + ($typeId == null ? 43 : $typeId.hashCode());
        DependencyDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ComponentDependency(targetComponentId=" + this.getTargetComponentId() + ", typeId=" + this.getTypeId() + ", direction=" + this.getDirection() + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ")";
    }

    @ConstructorProperties(value={"targetComponentId", "typeId", "direction", "label", "description"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentDependency(String targetComponentId, String typeId, DependencyDirection direction, String label, String description) {
        this.targetComponentId = targetComponentId;
        this.typeId = typeId;
        this.direction = direction;
        this.label = label;
        this.description = description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentDependency withTargetComponentId(String targetComponentId) {
        return this.targetComponentId == targetComponentId ? this : new ComponentDependency(targetComponentId, this.typeId, this.direction, this.label, this.description);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentDependency withTypeId(String typeId) {
        return this.typeId == typeId ? this : new ComponentDependency(this.targetComponentId, typeId, this.direction, this.label, this.description);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentDependency withDirection(DependencyDirection direction) {
        return this.direction == direction ? this : new ComponentDependency(this.targetComponentId, this.typeId, direction, this.label, this.description);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentDependency withLabel(String label) {
        return this.label == label ? this : new ComponentDependency(this.targetComponentId, this.typeId, this.direction, label, this.description);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentDependency withDescription(String description) {
        return this.description == description ? this : new ComponentDependency(this.targetComponentId, this.typeId, this.direction, this.label, description);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ComponentDependencyBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String targetComponentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String typeId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DependencyDirection direction;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String label;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ComponentDependencyBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentDependencyBuilder targetComponentId(String targetComponentId) {
            this.targetComponentId = targetComponentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentDependencyBuilder typeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentDependencyBuilder direction(DependencyDirection direction) {
            this.direction = direction;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentDependencyBuilder label(String label) {
            this.label = label;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentDependencyBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentDependency build() {
            return new ComponentDependency(this.targetComponentId, this.typeId, this.direction, this.label, this.description);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ComponentDependency.ComponentDependencyBuilder(targetComponentId=" + this.targetComponentId + ", typeId=" + this.typeId + ", direction=" + this.direction + ", label=" + this.label + ", description=" + this.description + ")";
        }
    }
}

