/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.models.Tag;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=ComponentConnectionBuilder.class)
public final class ComponentConnection
implements ObjectWithReference {
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    @JsonAlias(value={"target"})
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String targetComponentId;
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String type;
    private final String label;
    private final String description;
    private final List<@Valid Tag> tags;

    public ComponentConnection(String targetComponentId, String type, String label, String description, List<@Valid Tag> tags) {
        this.targetComponentId = targetComponentId;
        this.type = type;
        this.label = label;
        this.description = description;
        this.tags = ListUtils.createUnmodifiableList(tags);
    }

    @Override
    public String reference() {
        return "==" + (Objects.nonNull(this.type) ? this.type : "") + "==> " + this.targetComponentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ComponentConnectionBuilder builder() {
        return new ComponentConnectionBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentConnectionBuilder toBuilder() {
        return new ComponentConnectionBuilder().targetComponentId(this.targetComponentId).type(this.type).label(this.label).description(this.description).tags(this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTargetComponentId() {
        return this.targetComponentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLabel() {
        return this.label;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Tag> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentConnection)) {
            return false;
        }
        ComponentConnection other = (ComponentConnection)o;
        String this$targetComponentId = this.getTargetComponentId();
        String other$targetComponentId = other.getTargetComponentId();
        if (this$targetComponentId == null ? other$targetComponentId != null : !this$targetComponentId.equals(other$targetComponentId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $targetComponentId = this.getTargetComponentId();
        result = result * 59 + ($targetComponentId == null ? 43 : $targetComponentId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ComponentConnection(targetComponentId=" + this.getTargetComponentId() + ", type=" + this.getType() + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentConnection withTargetComponentId(String targetComponentId) {
        return this.targetComponentId == targetComponentId ? this : new ComponentConnection(targetComponentId, this.type, this.label, this.description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentConnection withType(String type) {
        return this.type == type ? this : new ComponentConnection(this.targetComponentId, type, this.label, this.description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentConnection withLabel(String label) {
        return this.label == label ? this : new ComponentConnection(this.targetComponentId, this.type, label, this.description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentConnection withDescription(String description) {
        return this.description == description ? this : new ComponentConnection(this.targetComponentId, this.type, this.label, description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentConnection withTags(List<@Valid Tag> tags) {
        return this.tags == tags ? this : new ComponentConnection(this.targetComponentId, this.type, this.label, this.description, tags);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ComponentConnectionBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String targetComponentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String label;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Tag> tags;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ComponentConnectionBuilder() {
        }

        @JsonAlias(value={"target"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentConnectionBuilder targetComponentId(String targetComponentId) {
            this.targetComponentId = targetComponentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentConnectionBuilder type(String type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentConnectionBuilder label(String label) {
            this.label = label;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentConnectionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentConnectionBuilder tags(List<@Valid Tag> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentConnection build() {
            return new ComponentConnection(this.targetComponentId, this.type, this.label, this.description, this.tags);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ComponentConnection.ComponentConnectionBuilder(targetComponentId=" + this.targetComponentId + ", type=" + this.type + ", label=" + this.label + ", description=" + this.description + ", tags=" + this.tags + ")";
        }
    }
}

