/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.UniqueElements;
import tech.kronicle.sdk.jackson.TagOrStringDeserializer;
import tech.kronicle.sdk.models.Alias;
import tech.kronicle.sdk.models.ComponentConnection;
import tech.kronicle.sdk.models.ComponentDependency;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.ComponentTeam;
import tech.kronicle.sdk.models.CrossFunctionalRequirement;
import tech.kronicle.sdk.models.Doc;
import tech.kronicle.sdk.models.Link;
import tech.kronicle.sdk.models.ObjectWithId;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.models.RepoReference;
import tech.kronicle.sdk.models.Responsibility;
import tech.kronicle.sdk.models.ScannerError;
import tech.kronicle.sdk.models.Tag;
import tech.kronicle.sdk.models.TechDebt;
import tech.kronicle.sdk.models.TestResult;
import tech.kronicle.sdk.models.graphql.GraphQlSchema;
import tech.kronicle.sdk.models.openapi.OpenApiSpec;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=ComponentBuilder.class)
public final class Component
implements ObjectWithId,
ObjectWithReference {
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String id;
    @UniqueElements
    private final List<Alias> aliases;
    @NotBlank
    private final String name;
    private final Boolean discovered;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    @JsonAlias(value={"type"})
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String typeId;
    @JsonDeserialize(contentUsing=TagOrStringDeserializer.class)
    private final List<@Valid Tag> tags;
    @Valid
    private final RepoReference repo;
    private final String description;
    private final List<@Valid Responsibility> responsibilities;
    private final String notes;
    private final List<@Valid Link> links;
    private final List<@Valid ComponentTeam> teams;
    @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*")
    @JsonAlias(value={"platform"})
    private final @Pattern(regexp="[a-z][a-z0-9]*([.-][a-z0-9]+)*") String platformId;
    private final List<@Valid ComponentConnection> connections;
    @Deprecated
    private final List<@Valid ComponentDependency> dependencies;
    private final List<@Valid CrossFunctionalRequirement> crossFunctionalRequirements;
    private final List<@Valid TechDebt> techDebts;
    private final List<@Valid Doc> docs;
    private final List<@Valid OpenApiSpec> openApiSpecs;
    private final List<@Valid GraphQlSchema> graphQlSchemas;
    private final List<@Valid ComponentState> states;
    private final List<@Valid ScannerError> scannerErrors;
    private final List<@Valid TestResult> testResults;

    public Component(String id, List<Alias> aliases, String name, Boolean discovered, String typeId, List<Tag> tags, RepoReference repo, String description, List<Responsibility> responsibilities, String notes, List<Link> links, List<ComponentTeam> teams, String platformId, List<ComponentConnection> connections, List<ComponentDependency> dependencies, List<CrossFunctionalRequirement> crossFunctionalRequirements, List<TechDebt> techDebts, List<Doc> docs, List<OpenApiSpec> openApiSpecs, List<GraphQlSchema> graphQlSchemas, List<ComponentState> states, List<ScannerError> scannerErrors, List<TestResult> testResults) {
        this.id = id;
        this.aliases = ListUtils.createUnmodifiableList(aliases);
        this.name = name;
        this.discovered = discovered;
        this.typeId = typeId;
        this.tags = ListUtils.createUnmodifiableList(tags);
        this.repo = repo;
        this.description = description;
        this.responsibilities = ListUtils.createUnmodifiableList(responsibilities);
        this.notes = notes;
        this.links = links;
        this.teams = ListUtils.createUnmodifiableList(teams);
        this.platformId = platformId;
        this.connections = ListUtils.createUnmodifiableList(connections);
        this.dependencies = ListUtils.createUnmodifiableList(dependencies);
        this.crossFunctionalRequirements = ListUtils.createUnmodifiableList(crossFunctionalRequirements);
        this.techDebts = ListUtils.createUnmodifiableList(techDebts);
        this.docs = ListUtils.createUnmodifiableList(docs);
        this.openApiSpecs = ListUtils.createUnmodifiableList(openApiSpecs);
        this.graphQlSchemas = ListUtils.createUnmodifiableList(graphQlSchemas);
        this.states = ListUtils.createUnmodifiableList(states);
        this.scannerErrors = ListUtils.createUnmodifiableList(scannerErrors);
        this.testResults = ListUtils.createUnmodifiableList(testResults);
    }

    @Override
    public String reference() {
        return this.id;
    }

    public Component addTag(Tag tag) {
        return this.withTags(ListUtils.unmodifiableUnionOfLists(List.of(this.tags, List.of(tag))));
    }

    public Component addTags(List<Tag> tags) {
        return this.withTags(ListUtils.unmodifiableUnionOfLists(List.of(this.tags, tags)));
    }

    public Component addState(ComponentState state) {
        return this.withStates(ListUtils.unmodifiableUnionOfLists(List.of(this.states, List.of(state))));
    }

    public Component addStates(List<ComponentState> states) {
        return this.withStates(ListUtils.unmodifiableUnionOfLists(List.of(this.states, states)));
    }

    @JsonIgnore
    public <T extends ComponentState> List<T> getStates(String type) {
        return this.states.stream().filter(state -> Objects.equals(state.getType(), type)).map(state -> state).collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public <T extends ComponentState> T getState(String type) {
        List<T> matches = this.getStates(type);
        if (matches.size() > 1) {
            throw new IllegalArgumentException("There are more than 1 states with type \"" + type + "\"");
        }
        if (matches.isEmpty()) {
            return null;
        }
        return (T)((ComponentState)matches.get(0));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ComponentBuilder builder() {
        return new ComponentBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentBuilder toBuilder() {
        return new ComponentBuilder().id(this.id).aliases(this.aliases).name(this.name).discovered(this.discovered).typeId(this.typeId).tags(this.tags).repo(this.repo).description(this.description).responsibilities(this.responsibilities).notes(this.notes).links(this.links).teams(this.teams).platformId(this.platformId).connections(this.connections).dependencies(this.dependencies).crossFunctionalRequirements(this.crossFunctionalRequirements).techDebts(this.techDebts).docs(this.docs).openApiSpecs(this.openApiSpecs).graphQlSchemas(this.graphQlSchemas).states(this.states).scannerErrors(this.scannerErrors).testResults(this.testResults);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Alias> getAliases() {
        return this.aliases;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getDiscovered() {
        return this.discovered;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTypeId() {
        return this.typeId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Tag> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RepoReference getRepo() {
        return this.repo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Responsibility> getResponsibilities() {
        return this.responsibilities;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNotes() {
        return this.notes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Link> getLinks() {
        return this.links;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ComponentTeam> getTeams() {
        return this.teams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPlatformId() {
        return this.platformId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ComponentConnection> getConnections() {
        return this.connections;
    }

    @Deprecated
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ComponentDependency> getDependencies() {
        return this.dependencies;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid CrossFunctionalRequirement> getCrossFunctionalRequirements() {
        return this.crossFunctionalRequirements;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid TechDebt> getTechDebts() {
        return this.techDebts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Doc> getDocs() {
        return this.docs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid OpenApiSpec> getOpenApiSpecs() {
        return this.openApiSpecs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid GraphQlSchema> getGraphQlSchemas() {
        return this.graphQlSchemas;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ComponentState> getStates() {
        return this.states;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ScannerError> getScannerErrors() {
        return this.scannerErrors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid TestResult> getTestResults() {
        return this.testResults;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component other = (Component)o;
        Boolean this$discovered = this.getDiscovered();
        Boolean other$discovered = other.getDiscovered();
        if (this$discovered == null ? other$discovered != null : !((Object)this$discovered).equals(other$discovered)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Alias> this$aliases = this.getAliases();
        List<Alias> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$typeId = this.getTypeId();
        String other$typeId = other.getTypeId();
        if (this$typeId == null ? other$typeId != null : !this$typeId.equals(other$typeId)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        RepoReference this$repo = this.getRepo();
        RepoReference other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !((Object)this$repo).equals(other$repo)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Responsibility> this$responsibilities = this.getResponsibilities();
        List<Responsibility> other$responsibilities = other.getResponsibilities();
        if (this$responsibilities == null ? other$responsibilities != null : !((Object)this$responsibilities).equals(other$responsibilities)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        List<Link> this$links = this.getLinks();
        List<Link> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        List<ComponentTeam> this$teams = this.getTeams();
        List<ComponentTeam> other$teams = other.getTeams();
        if (this$teams == null ? other$teams != null : !((Object)this$teams).equals(other$teams)) {
            return false;
        }
        String this$platformId = this.getPlatformId();
        String other$platformId = other.getPlatformId();
        if (this$platformId == null ? other$platformId != null : !this$platformId.equals(other$platformId)) {
            return false;
        }
        List<ComponentConnection> this$connections = this.getConnections();
        List<ComponentConnection> other$connections = other.getConnections();
        if (this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections)) {
            return false;
        }
        List<ComponentDependency> this$dependencies = this.getDependencies();
        List<ComponentDependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<CrossFunctionalRequirement> this$crossFunctionalRequirements = this.getCrossFunctionalRequirements();
        List<CrossFunctionalRequirement> other$crossFunctionalRequirements = other.getCrossFunctionalRequirements();
        if (this$crossFunctionalRequirements == null ? other$crossFunctionalRequirements != null : !((Object)this$crossFunctionalRequirements).equals(other$crossFunctionalRequirements)) {
            return false;
        }
        List<TechDebt> this$techDebts = this.getTechDebts();
        List<TechDebt> other$techDebts = other.getTechDebts();
        if (this$techDebts == null ? other$techDebts != null : !((Object)this$techDebts).equals(other$techDebts)) {
            return false;
        }
        List<Doc> this$docs = this.getDocs();
        List<Doc> other$docs = other.getDocs();
        if (this$docs == null ? other$docs != null : !((Object)this$docs).equals(other$docs)) {
            return false;
        }
        List<OpenApiSpec> this$openApiSpecs = this.getOpenApiSpecs();
        List<OpenApiSpec> other$openApiSpecs = other.getOpenApiSpecs();
        if (this$openApiSpecs == null ? other$openApiSpecs != null : !((Object)this$openApiSpecs).equals(other$openApiSpecs)) {
            return false;
        }
        List<GraphQlSchema> this$graphQlSchemas = this.getGraphQlSchemas();
        List<GraphQlSchema> other$graphQlSchemas = other.getGraphQlSchemas();
        if (this$graphQlSchemas == null ? other$graphQlSchemas != null : !((Object)this$graphQlSchemas).equals(other$graphQlSchemas)) {
            return false;
        }
        List<ComponentState> this$states = this.getStates();
        List<ComponentState> other$states = other.getStates();
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        List<ScannerError> this$scannerErrors = this.getScannerErrors();
        List<ScannerError> other$scannerErrors = other.getScannerErrors();
        if (this$scannerErrors == null ? other$scannerErrors != null : !((Object)this$scannerErrors).equals(other$scannerErrors)) {
            return false;
        }
        List<TestResult> this$testResults = this.getTestResults();
        List<TestResult> other$testResults = other.getTestResults();
        return !(this$testResults == null ? other$testResults != null : !((Object)this$testResults).equals(other$testResults));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $discovered = this.getDiscovered();
        result = result * 59 + ($discovered == null ? 43 : ((Object)$discovered).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Alias> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $typeId = this.getTypeId();
        result = result * 59 + ($typeId == null ? 43 : $typeId.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        RepoReference $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : ((Object)$repo).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Responsibility> $responsibilities = this.getResponsibilities();
        result = result * 59 + ($responsibilities == null ? 43 : ((Object)$responsibilities).hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        List<Link> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        List<ComponentTeam> $teams = this.getTeams();
        result = result * 59 + ($teams == null ? 43 : ((Object)$teams).hashCode());
        String $platformId = this.getPlatformId();
        result = result * 59 + ($platformId == null ? 43 : $platformId.hashCode());
        List<ComponentConnection> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        List<ComponentDependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<CrossFunctionalRequirement> $crossFunctionalRequirements = this.getCrossFunctionalRequirements();
        result = result * 59 + ($crossFunctionalRequirements == null ? 43 : ((Object)$crossFunctionalRequirements).hashCode());
        List<TechDebt> $techDebts = this.getTechDebts();
        result = result * 59 + ($techDebts == null ? 43 : ((Object)$techDebts).hashCode());
        List<Doc> $docs = this.getDocs();
        result = result * 59 + ($docs == null ? 43 : ((Object)$docs).hashCode());
        List<OpenApiSpec> $openApiSpecs = this.getOpenApiSpecs();
        result = result * 59 + ($openApiSpecs == null ? 43 : ((Object)$openApiSpecs).hashCode());
        List<GraphQlSchema> $graphQlSchemas = this.getGraphQlSchemas();
        result = result * 59 + ($graphQlSchemas == null ? 43 : ((Object)$graphQlSchemas).hashCode());
        List<ComponentState> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        List<ScannerError> $scannerErrors = this.getScannerErrors();
        result = result * 59 + ($scannerErrors == null ? 43 : ((Object)$scannerErrors).hashCode());
        List<TestResult> $testResults = this.getTestResults();
        result = result * 59 + ($testResults == null ? 43 : ((Object)$testResults).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Component(id=" + this.getId() + ", aliases=" + this.getAliases() + ", name=" + this.getName() + ", discovered=" + this.getDiscovered() + ", typeId=" + this.getTypeId() + ", tags=" + this.getTags() + ", repo=" + this.getRepo() + ", description=" + this.getDescription() + ", responsibilities=" + this.getResponsibilities() + ", notes=" + this.getNotes() + ", links=" + this.getLinks() + ", teams=" + this.getTeams() + ", platformId=" + this.getPlatformId() + ", connections=" + this.getConnections() + ", dependencies=" + this.getDependencies() + ", crossFunctionalRequirements=" + this.getCrossFunctionalRequirements() + ", techDebts=" + this.getTechDebts() + ", docs=" + this.getDocs() + ", openApiSpecs=" + this.getOpenApiSpecs() + ", graphQlSchemas=" + this.getGraphQlSchemas() + ", states=" + this.getStates() + ", scannerErrors=" + this.getScannerErrors() + ", testResults=" + this.getTestResults() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withId(String id) {
        return this.id == id ? this : new Component(id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withAliases(List<Alias> aliases) {
        return this.aliases == aliases ? this : new Component(this.id, aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withName(String name) {
        return this.name == name ? this : new Component(this.id, this.aliases, name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withDiscovered(Boolean discovered) {
        return this.discovered == discovered ? this : new Component(this.id, this.aliases, this.name, discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTypeId(String typeId) {
        return this.typeId == typeId ? this : new Component(this.id, this.aliases, this.name, this.discovered, typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTags(List<@Valid Tag> tags) {
        return this.tags == tags ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withRepo(RepoReference repo) {
        return this.repo == repo ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withDescription(String description) {
        return this.description == description ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withResponsibilities(List<@Valid Responsibility> responsibilities) {
        return this.responsibilities == responsibilities ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withNotes(String notes) {
        return this.notes == notes ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withLinks(List<@Valid Link> links) {
        return this.links == links ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTeams(List<@Valid ComponentTeam> teams) {
        return this.teams == teams ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withPlatformId(String platformId) {
        return this.platformId == platformId ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withConnections(List<@Valid ComponentConnection> connections) {
        return this.connections == connections ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @Deprecated
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withDependencies(List<@Valid ComponentDependency> dependencies) {
        return this.dependencies == dependencies ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withCrossFunctionalRequirements(List<@Valid CrossFunctionalRequirement> crossFunctionalRequirements) {
        return this.crossFunctionalRequirements == crossFunctionalRequirements ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTechDebts(List<@Valid TechDebt> techDebts) {
        return this.techDebts == techDebts ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withDocs(List<@Valid Doc> docs) {
        return this.docs == docs ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withOpenApiSpecs(List<@Valid OpenApiSpec> openApiSpecs) {
        return this.openApiSpecs == openApiSpecs ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withGraphQlSchemas(List<@Valid GraphQlSchema> graphQlSchemas) {
        return this.graphQlSchemas == graphQlSchemas ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, graphQlSchemas, this.states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withStates(List<@Valid ComponentState> states) {
        return this.states == states ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, states, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withScannerErrors(List<@Valid ScannerError> scannerErrors) {
        return this.scannerErrors == scannerErrors ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTestResults(List<@Valid TestResult> testResults) {
        return this.testResults == testResults ? this : new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, testResults);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ComponentBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Alias> aliases;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean discovered;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String typeId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Tag> tags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private RepoReference repo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Responsibility> responsibilities;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String notes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Link> links;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ComponentTeam> teams;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String platformId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ComponentConnection> connections;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ComponentDependency> dependencies;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid CrossFunctionalRequirement> crossFunctionalRequirements;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid TechDebt> techDebts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Doc> docs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid OpenApiSpec> openApiSpecs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid GraphQlSchema> graphQlSchemas;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ComponentState> states;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ScannerError> scannerErrors;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid TestResult> testResults;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ComponentBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder aliases(List<Alias> aliases) {
            this.aliases = aliases;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder discovered(Boolean discovered) {
            this.discovered = discovered;
            return this;
        }

        @JsonAlias(value={"type"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder typeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        @JsonDeserialize(contentUsing=TagOrStringDeserializer.class)
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder tags(List<@Valid Tag> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder repo(RepoReference repo) {
            this.repo = repo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder responsibilities(List<@Valid Responsibility> responsibilities) {
            this.responsibilities = responsibilities;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder notes(String notes) {
            this.notes = notes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder links(List<@Valid Link> links) {
            this.links = links;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder teams(List<@Valid ComponentTeam> teams) {
            this.teams = teams;
            return this;
        }

        @JsonAlias(value={"platform"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder connections(List<@Valid ComponentConnection> connections) {
            this.connections = connections;
            return this;
        }

        @Deprecated
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder dependencies(List<@Valid ComponentDependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder crossFunctionalRequirements(List<@Valid CrossFunctionalRequirement> crossFunctionalRequirements) {
            this.crossFunctionalRequirements = crossFunctionalRequirements;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder techDebts(List<@Valid TechDebt> techDebts) {
            this.techDebts = techDebts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder docs(List<@Valid Doc> docs) {
            this.docs = docs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder openApiSpecs(List<@Valid OpenApiSpec> openApiSpecs) {
            this.openApiSpecs = openApiSpecs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder graphQlSchemas(List<@Valid GraphQlSchema> graphQlSchemas) {
            this.graphQlSchemas = graphQlSchemas;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder states(List<@Valid ComponentState> states) {
            this.states = states;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder scannerErrors(List<@Valid ScannerError> scannerErrors) {
            this.scannerErrors = scannerErrors;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder testResults(List<@Valid TestResult> testResults) {
            this.testResults = testResults;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Component build() {
            return new Component(this.id, this.aliases, this.name, this.discovered, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.connections, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.docs, this.openApiSpecs, this.graphQlSchemas, this.states, this.scannerErrors, this.testResults);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Component.ComponentBuilder(id=" + this.id + ", aliases=" + this.aliases + ", name=" + this.name + ", discovered=" + this.discovered + ", typeId=" + this.typeId + ", tags=" + this.tags + ", repo=" + this.repo + ", description=" + this.description + ", responsibilities=" + this.responsibilities + ", notes=" + this.notes + ", links=" + this.links + ", teams=" + this.teams + ", platformId=" + this.platformId + ", connections=" + this.connections + ", dependencies=" + this.dependencies + ", crossFunctionalRequirements=" + this.crossFunctionalRequirements + ", techDebts=" + this.techDebts + ", docs=" + this.docs + ", openApiSpecs=" + this.openApiSpecs + ", graphQlSchemas=" + this.graphQlSchemas + ", states=" + this.states + ", scannerErrors=" + this.scannerErrors + ", testResults=" + this.testResults + ")";
        }
    }
}

