/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models.git;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.git.Identity;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=GitRepoStateBuilder.class)
public final class GitRepoState
implements ComponentState {
    public static final String TYPE = "git-repo";
    private final String type = "git-repo";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    private final String id;
    private final LocalDateTime firstCommitTimestamp;
    private final LocalDateTime lastCommitTimestamp;
    private final Integer commitCount;
    private final List<Identity> authors;
    private final List<Identity> committers;
    private final Integer authorCount;
    private final Integer committerCount;

    public GitRepoState(String pluginId, LocalDateTime firstCommitTimestamp, LocalDateTime lastCommitTimestamp, Integer commitCount, List<Identity> authors, List<Identity> committers, Integer authorCount, Integer committerCount) {
        this.id = null;
        this.pluginId = pluginId;
        this.firstCommitTimestamp = firstCommitTimestamp;
        this.lastCommitTimestamp = lastCommitTimestamp;
        this.commitCount = commitCount;
        this.authors = ListUtils.createUnmodifiableList(authors);
        this.committers = ListUtils.createUnmodifiableList(committers);
        this.authorCount = authorCount;
        this.committerCount = committerCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static GitRepoStateBuilder builder() {
        return new GitRepoStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoStateBuilder toBuilder() {
        return new GitRepoStateBuilder().pluginId(this.pluginId).firstCommitTimestamp(this.firstCommitTimestamp).lastCommitTimestamp(this.lastCommitTimestamp).commitCount(this.commitCount).authors(this.authors).committers(this.committers).authorCount(this.authorCount).committerCount(this.committerCount);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getFirstCommitTimestamp() {
        return this.firstCommitTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getLastCommitTimestamp() {
        return this.lastCommitTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getCommitCount() {
        return this.commitCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Identity> getAuthors() {
        return this.authors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Identity> getCommitters() {
        return this.committers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getAuthorCount() {
        return this.authorCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getCommitterCount() {
        return this.committerCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitRepoState)) {
            return false;
        }
        GitRepoState other = (GitRepoState)o;
        Integer this$commitCount = this.getCommitCount();
        Integer other$commitCount = other.getCommitCount();
        if (this$commitCount == null ? other$commitCount != null : !((Object)this$commitCount).equals(other$commitCount)) {
            return false;
        }
        Integer this$authorCount = this.getAuthorCount();
        Integer other$authorCount = other.getAuthorCount();
        if (this$authorCount == null ? other$authorCount != null : !((Object)this$authorCount).equals(other$authorCount)) {
            return false;
        }
        Integer this$committerCount = this.getCommitterCount();
        Integer other$committerCount = other.getCommitterCount();
        if (this$committerCount == null ? other$committerCount != null : !((Object)this$committerCount).equals(other$committerCount)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LocalDateTime this$firstCommitTimestamp = this.getFirstCommitTimestamp();
        LocalDateTime other$firstCommitTimestamp = other.getFirstCommitTimestamp();
        if (this$firstCommitTimestamp == null ? other$firstCommitTimestamp != null : !((Object)this$firstCommitTimestamp).equals(other$firstCommitTimestamp)) {
            return false;
        }
        LocalDateTime this$lastCommitTimestamp = this.getLastCommitTimestamp();
        LocalDateTime other$lastCommitTimestamp = other.getLastCommitTimestamp();
        if (this$lastCommitTimestamp == null ? other$lastCommitTimestamp != null : !((Object)this$lastCommitTimestamp).equals(other$lastCommitTimestamp)) {
            return false;
        }
        List<Identity> this$authors = this.getAuthors();
        List<Identity> other$authors = other.getAuthors();
        if (this$authors == null ? other$authors != null : !((Object)this$authors).equals(other$authors)) {
            return false;
        }
        List<Identity> this$committers = this.getCommitters();
        List<Identity> other$committers = other.getCommitters();
        return !(this$committers == null ? other$committers != null : !((Object)this$committers).equals(other$committers));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $commitCount = this.getCommitCount();
        result = result * 59 + ($commitCount == null ? 43 : ((Object)$commitCount).hashCode());
        Integer $authorCount = this.getAuthorCount();
        result = result * 59 + ($authorCount == null ? 43 : ((Object)$authorCount).hashCode());
        Integer $committerCount = this.getCommitterCount();
        result = result * 59 + ($committerCount == null ? 43 : ((Object)$committerCount).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LocalDateTime $firstCommitTimestamp = this.getFirstCommitTimestamp();
        result = result * 59 + ($firstCommitTimestamp == null ? 43 : ((Object)$firstCommitTimestamp).hashCode());
        LocalDateTime $lastCommitTimestamp = this.getLastCommitTimestamp();
        result = result * 59 + ($lastCommitTimestamp == null ? 43 : ((Object)$lastCommitTimestamp).hashCode());
        List<Identity> $authors = this.getAuthors();
        result = result * 59 + ($authors == null ? 43 : ((Object)$authors).hashCode());
        List<Identity> $committers = this.getCommitters();
        result = result * 59 + ($committers == null ? 43 : ((Object)$committers).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "GitRepoState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", firstCommitTimestamp=" + this.getFirstCommitTimestamp() + ", lastCommitTimestamp=" + this.getLastCommitTimestamp() + ", commitCount=" + this.getCommitCount() + ", authors=" + this.getAuthors() + ", committers=" + this.getCommitters() + ", authorCount=" + this.getAuthorCount() + ", committerCount=" + this.getCommitterCount() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new GitRepoState(pluginId, this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoState withFirstCommitTimestamp(LocalDateTime firstCommitTimestamp) {
        return this.firstCommitTimestamp == firstCommitTimestamp ? this : new GitRepoState(this.pluginId, firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoState withLastCommitTimestamp(LocalDateTime lastCommitTimestamp) {
        return this.lastCommitTimestamp == lastCommitTimestamp ? this : new GitRepoState(this.pluginId, this.firstCommitTimestamp, lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoState withCommitCount(Integer commitCount) {
        return this.commitCount == commitCount ? this : new GitRepoState(this.pluginId, this.firstCommitTimestamp, this.lastCommitTimestamp, commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoState withAuthors(List<Identity> authors) {
        return this.authors == authors ? this : new GitRepoState(this.pluginId, this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoState withCommitters(List<Identity> committers) {
        return this.committers == committers ? this : new GitRepoState(this.pluginId, this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoState withAuthorCount(Integer authorCount) {
        return this.authorCount == authorCount ? this : new GitRepoState(this.pluginId, this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoState withCommitterCount(Integer committerCount) {
        return this.committerCount == committerCount ? this : new GitRepoState(this.pluginId, this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, committerCount);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class GitRepoStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime firstCommitTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime lastCommitTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer commitCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Identity> authors;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Identity> committers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer authorCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer committerCount;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        GitRepoStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoStateBuilder firstCommitTimestamp(LocalDateTime firstCommitTimestamp) {
            this.firstCommitTimestamp = firstCommitTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoStateBuilder lastCommitTimestamp(LocalDateTime lastCommitTimestamp) {
            this.lastCommitTimestamp = lastCommitTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoStateBuilder commitCount(Integer commitCount) {
            this.commitCount = commitCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoStateBuilder authors(List<Identity> authors) {
            this.authors = authors;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoStateBuilder committers(List<Identity> committers) {
            this.committers = committers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoStateBuilder authorCount(Integer authorCount) {
            this.authorCount = authorCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoStateBuilder committerCount(Integer committerCount) {
            this.committerCount = committerCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoState build() {
            return new GitRepoState(this.pluginId, this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GitRepoState.GitRepoStateBuilder(pluginId=" + this.pluginId + ", firstCommitTimestamp=" + this.firstCommitTimestamp + ", lastCommitTimestamp=" + this.lastCommitTimestamp + ", commitCount=" + this.commitCount + ", authors=" + this.authors + ", committers=" + this.committers + ", authorCount=" + this.authorCount + ", committerCount=" + this.committerCount + ")";
        }
    }
}

