/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.utils.ListUtils;

public final class Repo
implements ObjectWithReference {
    @NotBlank
    private final String url;
    private final String description;
    private final String defaultBranch;
    @NotNull
    private final Boolean hasComponentMetadataFile;
    private final @NotNull List<@Valid ComponentState> states;

    public Repo(String url, String description, String defaultBranch, Boolean hasComponentMetadataFile, List<ComponentState> states) {
        this.url = url;
        this.description = description;
        this.defaultBranch = defaultBranch;
        this.hasComponentMetadataFile = hasComponentMetadataFile;
        this.states = ListUtils.createUnmodifiableList(states);
    }

    @Override
    public String reference() {
        return this.url;
    }

    public Repo addStates(List<ComponentState> states) {
        return this.withStates(ListUtils.unmodifiableUnionOfLists(List.of(this.states, states)));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static RepoBuilder builder() {
        return new RepoBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RepoBuilder toBuilder() {
        return new RepoBuilder().url(this.url).description(this.description).defaultBranch(this.defaultBranch).hasComponentMetadataFile(this.hasComponentMetadataFile).states(this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUrl() {
        return this.url;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getHasComponentMetadataFile() {
        return this.hasComponentMetadataFile;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid ComponentState> getStates() {
        return this.states;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Repo)) {
            return false;
        }
        Repo other = (Repo)o;
        Boolean this$hasComponentMetadataFile = this.getHasComponentMetadataFile();
        Boolean other$hasComponentMetadataFile = other.getHasComponentMetadataFile();
        if (this$hasComponentMetadataFile == null ? other$hasComponentMetadataFile != null : !((Object)this$hasComponentMetadataFile).equals(other$hasComponentMetadataFile)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$defaultBranch = this.getDefaultBranch();
        String other$defaultBranch = other.getDefaultBranch();
        if (this$defaultBranch == null ? other$defaultBranch != null : !this$defaultBranch.equals(other$defaultBranch)) {
            return false;
        }
        List<ComponentState> this$states = this.getStates();
        List<ComponentState> other$states = other.getStates();
        return !(this$states == null ? other$states != null : !((Object)this$states).equals(other$states));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hasComponentMetadataFile = this.getHasComponentMetadataFile();
        result = result * 59 + ($hasComponentMetadataFile == null ? 43 : ((Object)$hasComponentMetadataFile).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $defaultBranch = this.getDefaultBranch();
        result = result * 59 + ($defaultBranch == null ? 43 : $defaultBranch.hashCode());
        List<ComponentState> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Repo(url=" + this.getUrl() + ", description=" + this.getDescription() + ", defaultBranch=" + this.getDefaultBranch() + ", hasComponentMetadataFile=" + this.getHasComponentMetadataFile() + ", states=" + this.getStates() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Repo withUrl(String url) {
        return this.url == url ? this : new Repo(url, this.description, this.defaultBranch, this.hasComponentMetadataFile, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Repo withDescription(String description) {
        return this.description == description ? this : new Repo(this.url, description, this.defaultBranch, this.hasComponentMetadataFile, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Repo withDefaultBranch(String defaultBranch) {
        return this.defaultBranch == defaultBranch ? this : new Repo(this.url, this.description, defaultBranch, this.hasComponentMetadataFile, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Repo withHasComponentMetadataFile(@NotNull Boolean hasComponentMetadataFile) {
        return this.hasComponentMetadataFile == hasComponentMetadataFile ? this : new Repo(this.url, this.description, this.defaultBranch, hasComponentMetadataFile, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Repo withStates(@NotNull List<@Valid ComponentState> states) {
        return this.states == states ? this : new Repo(this.url, this.description, this.defaultBranch, this.hasComponentMetadataFile, states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class RepoBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String url;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String defaultBranch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean hasComponentMetadataFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ComponentState> states;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        RepoBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RepoBuilder url(String url) {
            this.url = url;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RepoBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RepoBuilder defaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RepoBuilder hasComponentMetadataFile(@NotNull Boolean hasComponentMetadataFile) {
            this.hasComponentMetadataFile = hasComponentMetadataFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RepoBuilder states(@NotNull List<@Valid ComponentState> states) {
            this.states = states;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Repo build() {
            return new Repo(this.url, this.description, this.defaultBranch, this.hasComponentMetadataFile, this.states);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Repo.RepoBuilder(url=" + this.url + ", description=" + this.description + ", defaultBranch=" + this.defaultBranch + ", hasComponentMetadataFile=" + this.hasComponentMetadataFile + ", states=" + this.states + ")";
        }
    }
}

