/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.Import;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=ImportsStateBuilder.class)
public final class ImportsState
implements ComponentState {
    public static final String TYPE = "imports";
    private final String type = "imports";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    private final String id;
    private final @NotNull List<@Valid Import> imports;

    public ImportsState(String pluginId, List<@Valid Import> imports) {
        this.id = null;
        this.pluginId = pluginId;
        this.imports = ListUtils.createUnmodifiableList(imports);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ImportsStateBuilder builder() {
        return new ImportsStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImportsStateBuilder toBuilder() {
        return new ImportsStateBuilder().pluginId(this.pluginId).imports(this.imports);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid Import> getImports() {
        return this.imports;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportsState)) {
            return false;
        }
        ImportsState other = (ImportsState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Import> this$imports = this.getImports();
        List<Import> other$imports = other.getImports();
        return !(this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Import> $imports = this.getImports();
        result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ImportsState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", id=" + this.getId() + ", imports=" + this.getImports() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImportsState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new ImportsState(pluginId, this.imports);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImportsState withImports(@NotNull List<@Valid Import> imports) {
        return this.imports == imports ? this : new ImportsState(this.pluginId, imports);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ImportsStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Import> imports;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ImportsStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ImportsStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ImportsStateBuilder imports(@NotNull List<@Valid Import> imports) {
            this.imports = imports;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ImportsState build() {
            return new ImportsState(this.pluginId, this.imports);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ImportsState.ImportsStateBuilder(pluginId=" + this.pluginId + ", imports=" + this.imports + ")";
        }
    }
}

