/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugintestutils;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import tech.kronicle.plugintestutils.SimplifiedLogEvent;

public class LogCaptor
implements AutoCloseable {
    private final ListAppender<ILoggingEvent> appender = new ListAppender();
    private final List<ILoggingEvent> events;
    private final Logger logger;
    private final Level initialLevel;

    public LogCaptor(Class<?> clazz) {
        this.appender.start();
        this.events = Collections.unmodifiableList(this.appender.list);
        this.logger = (Logger)LoggerFactory.getLogger((String)clazz.getName());
        this.initialLevel = this.logger.getLevel();
        this.logger.setLevel(Level.ALL);
        this.logger.addAppender(this.appender);
    }

    public List<ILoggingEvent> getEvents() {
        return this.events;
    }

    public List<SimplifiedLogEvent> getSimplifiedEvents() {
        return this.events.stream().map(event -> new SimplifiedLogEvent(event.getLevel(), event.getFormattedMessage())).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.logger.detachAppender(this.appender);
        this.logger.setLevel(this.initialLevel);
        this.appender.stop();
    }
}

