/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.pluginapi.finders.models;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.pluginapi.finders.models.GenericTrace;
import tech.kronicle.sdk.models.Dependency;
import tech.kronicle.sdk.models.Diagram;
import tech.kronicle.sdk.models.GraphEdge;
import tech.kronicle.sdk.models.GraphNode;
import tech.kronicle.sdk.models.GraphState;
import tech.kronicle.sdk.utils.ListUtils;

public final class TracingData {
    public static final TracingData EMPTY = TracingData.builder().build();
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String environmentId;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String id;
    @NotBlank
    private final String name;
    private final List<Dependency> dependencies;
    private final List<GenericTrace> traces;

    public TracingData(String pluginId, String environmentId, String id, String name, List<Dependency> dependencies, List<GenericTrace> traces) {
        this.pluginId = pluginId;
        this.environmentId = environmentId;
        this.id = id;
        this.name = name;
        this.dependencies = ListUtils.createUnmodifiableList(dependencies);
        this.traces = ListUtils.createUnmodifiableList(traces);
    }

    public Diagram toDiagram(String diagramType, List<GraphNode> nodes, List<GraphEdge> edges, Integer sampleSize) {
        return Diagram.builder().id(this.getId()).name(this.getName()).discovered(Boolean.valueOf(true)).type(diagramType).states(List.of(GraphState.builder().pluginId(this.getPluginId()).environmentId(this.getEnvironmentId()).nodes(nodes).edges(edges).sampleSize(sampleSize).build())).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static TracingDataBuilder builder() {
        return new TracingDataBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TracingDataBuilder toBuilder() {
        return new TracingDataBuilder().pluginId(this.pluginId).environmentId(this.environmentId).id(this.id).name(this.name).dependencies(this.dependencies).traces(this.traces);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<GenericTrace> getTraces() {
        return this.traces;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TracingData)) {
            return false;
        }
        TracingData other = (TracingData)o;
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Dependency> this$dependencies = this.getDependencies();
        List<Dependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<GenericTrace> this$traces = this.getTraces();
        List<GenericTrace> other$traces = other.getTraces();
        return !(this$traces == null ? other$traces != null : !((Object)this$traces).equals(other$traces));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<GenericTrace> $traces = this.getTraces();
        result = result * 59 + ($traces == null ? 43 : ((Object)$traces).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "TracingData(pluginId=" + this.getPluginId() + ", environmentId=" + this.getEnvironmentId() + ", id=" + this.getId() + ", name=" + this.getName() + ", dependencies=" + this.getDependencies() + ", traces=" + this.getTraces() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class TracingDataBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String environmentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Dependency> dependencies;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<GenericTrace> traces;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TracingDataBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TracingDataBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TracingDataBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TracingDataBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TracingDataBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TracingDataBuilder dependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TracingDataBuilder traces(List<GenericTrace> traces) {
            this.traces = traces;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TracingData build() {
            return new TracingData(this.pluginId, this.environmentId, this.id, this.name, this.dependencies, this.traces);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TracingData.TracingDataBuilder(pluginId=" + this.pluginId + ", environmentId=" + this.environmentId + ", id=" + this.id + ", name=" + this.name + ", dependencies=" + this.dependencies + ", traces=" + this.traces + ")";
        }
    }
}

