/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.pluginapi.scanners;

import java.util.ArrayList;
import java.util.List;
import tech.kronicle.common.CaseUtils;
import tech.kronicle.pluginapi.ExtensionPointWithId;
import tech.kronicle.pluginapi.scanners.models.Output;
import tech.kronicle.sdk.models.ComponentMetadata;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.models.ObjectWithScannerId;
import tech.kronicle.sdk.models.Summary;

public abstract class Scanner<I extends ObjectWithReference, O>
implements ExtensionPointWithId {
    @Override
    public String id() {
        return CaseUtils.toKebabCase((String)this.getClass().getSimpleName()).replaceFirst("-scanner$", "");
    }

    public abstract String description();

    public String notes() {
        return null;
    }

    public void refresh(ComponentMetadata componentMetadata) {
    }

    public abstract Output<O> scan(I var1);

    public Summary transformSummary(Summary summary) {
        return summary;
    }

    protected <T extends ObjectWithScannerId> List<T> replaceScannerItemsInList(List<T> list, List<T> newItems) {
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.removeIf(item -> item.getScannerId().equals(this.id()));
        newList.addAll(newItems);
        return newList;
    }
}

