/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.validation.Validation;
import javax.validation.Validator;
import tech.kronicle.common.ValidationConstraintViolationTransformer;
import tech.kronicle.common.ValidatorService;
import tech.kronicle.sdk.models.ComponentMetadata;

public class KronicleMetadataValidator {
    private static final YAMLMapper YAML_MAPPER = new YAMLMapper();
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
    private static final ValidationConstraintViolationTransformer CONSTRAINT_VIOLATION_TRANSFORMER = new ValidationConstraintViolationTransformer();
    private static final ValidatorService VALIDATION_SERVICE = new ValidatorService(VALIDATOR, CONSTRAINT_VIOLATION_TRANSFORMER);

    private KronicleMetadataValidator() {
    }

    public static void validate(File componentMetadataFile) throws IOException {
        KronicleMetadataValidator.validate(Files.readString(componentMetadataFile.toPath()));
    }

    public static void validate(String componentMetadataYaml) throws JsonProcessingException {
        KronicleMetadataValidator.validate((ComponentMetadata)YAML_MAPPER.readValue(componentMetadataYaml, ComponentMetadata.class));
    }

    public static void validate(ComponentMetadata componentMetadata) {
        VALIDATION_SERVICE.validate((Object)componentMetadata, "Component Metadata file has failed validation");
    }

    static {
        YAML_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

