/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.Arrays;
import java.util.Collection;
import org.testng.IConfigurationListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.Utils;
import org.testng.reporters.RuntimeBehavior;

public class VerboseReporter
implements IConfigurationListener,
ITestListener {
    public static final String LISTENER_PREFIX = "[VerboseTestNG] ";
    private String suiteName;
    private final String prefix;

    public VerboseReporter(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void beforeConfiguration(ITestResult tr) {
        this.logTestResult(Status.STARTED, tr, true);
    }

    @Override
    public void onConfigurationFailure(ITestResult tr) {
        this.logTestResult(Status.FAILURE, tr, true);
    }

    @Override
    public void onConfigurationSkip(ITestResult tr) {
        this.logTestResult(Status.SKIP, tr, true);
    }

    @Override
    public void onConfigurationSuccess(ITestResult tr) {
        this.logTestResult(Status.SUCCESS, tr, true);
    }

    @Override
    public void onTestStart(ITestResult tr) {
        this.logTestResult(Status.STARTED, tr, false);
    }

    @Override
    public void onTestFailure(ITestResult tr) {
        this.logTestResult(Status.FAILURE, tr, false);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.logTestResult(Status.SUCCESS_PERCENTAGE_FAILURE, tr, false);
    }

    @Override
    public void onTestSkipped(ITestResult tr) {
        this.logTestResult(Status.SKIP, tr, false);
    }

    @Override
    public void onTestSuccess(ITestResult tr) {
        this.logTestResult(Status.SUCCESS, tr, false);
    }

    @Override
    public void onStart(ITestContext ctx) {
        this.suiteName = ctx.getName();
        this.log("RUNNING: Suite: \"" + this.suiteName + "\" containing \"" + ctx.getAllTestMethods().length + "\" Tests (config: " + ctx.getSuite().getXmlSuite().getFileName() + ")");
    }

    @Override
    public void onFinish(ITestContext context) {
        this.logResults(context);
        this.suiteName = null;
    }

    private ITestNGMethod[] resultsToMethods(Collection<ITestResult> results) {
        return (ITestNGMethod[])results.stream().map(ITestResult::getMethod).toArray(ITestNGMethod[]::new);
    }

    private void logResults(ITestContext context) {
        ITestNGMethod[] ft = this.resultsToMethods(context.getFailedTests().getAllResults());
        StringBuilder sb = new StringBuilder("\n===============================================\n");
        sb.append("    ").append(this.suiteName).append("\n");
        sb.append("    Tests run: ").append(context.getAllTestMethods().length);
        sb.append(", Failures: ").append(ft.length);
        sb.append(", Skips: ").append(Arrays.toString(this.resultsToMethods(context.getSkippedTests().getAllResults())));
        int confFailures = context.getFailedConfigurations().size();
        int confSkips = context.getSkippedConfigurations().size();
        if (confFailures > 0 || confSkips > 0) {
            sb.append("\n").append("    Configuration Failures: ").append(confFailures);
            sb.append(", Skips: ").append(confSkips);
        }
        sb.append("\n===============================================");
        this.log(sb.toString());
    }

    private void logTestResult(Status st, ITestResult itr, boolean isConfMethod) {
        int i2;
        StringBuilder sb = new StringBuilder();
        String stackTrace = "";
        switch (st) {
            case STARTED: {
                sb.append("INVOKING");
                break;
            }
            case SKIP: {
                sb.append("SKIPPED");
                stackTrace = itr.getThrowable() != null ? Utils.shortStackTrace(itr.getThrowable(), false) : "";
                break;
            }
            case FAILURE: {
                sb.append("FAILED");
                stackTrace = itr.getThrowable() != null ? Utils.shortStackTrace(itr.getThrowable(), false) : "";
                break;
            }
            case SUCCESS: {
                sb.append("PASSED");
                break;
            }
            case SUCCESS_PERCENTAGE_FAILURE: {
                sb.append("PASSED with failures");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported test status:" + itr.getStatus());
            }
        }
        if (isConfMethod) {
            sb.append(" CONFIGURATION: ");
        } else {
            sb.append(": ");
        }
        ITestNGMethod tm = itr.getMethod();
        int identLevel = sb.length();
        sb.append(this.getMethodDeclaration(tm, itr));
        Object[] params = itr.getParameters();
        Class<?>[] paramTypes = Utils.extractParameterTypes(itr.getParameters());
        if (null != params && params.length > 0) {
            if (params.length != paramTypes.length) {
                sb.append("Wrong number of arguments were passed by the Data Provider: found ");
                sb.append(params.length);
                sb.append(" but expected ");
                sb.append(paramTypes.length);
            } else {
                sb.append("(value(s): ");
                for (i2 = 0; i2 < params.length; ++i2) {
                    if (i2 > 0) {
                        sb.append(", ");
                    }
                    sb.append(Utils.toString(params[i2], paramTypes[i2]));
                }
                sb.append(")");
            }
        }
        if (Status.STARTED != st) {
            sb.append(" finished in ");
            sb.append(itr.getEndMillis() - itr.getStartMillis());
            sb.append(" ms");
            if (!Utils.isStringEmpty(tm.getDescription())) {
                sb.append("\n");
                for (i2 = 0; i2 < identLevel; ++i2) {
                    sb.append(" ");
                }
                sb.append(tm.getDescription());
            }
            if (tm.getInvocationCount() > 1) {
                sb.append(" (");
                sb.append(tm.getCurrentInvocationCount());
                sb.append(" of ");
                sb.append(tm.getInvocationCount());
                sb.append(")");
            }
            if (!Utils.isStringEmpty(stackTrace)) {
                sb.append("\n").append(stackTrace, 0, stackTrace.lastIndexOf(RuntimeBehavior.getDefaultLineSeparator()));
            }
        } else if (!isConfMethod && tm.getInvocationCount() > 1) {
            sb.append(" success: ");
            sb.append(tm.getSuccessPercentage());
            sb.append("%");
        }
        this.log(sb.toString());
    }

    protected void log(String message) {
        System.out.println(message.replaceAll("(?m)^", this.prefix));
    }

    private String getMethodDeclaration(ITestNGMethod method, ITestResult tr) {
        StringBuilder buf = new StringBuilder();
        buf.append("\"");
        if (this.suiteName != null) {
            buf.append(this.suiteName);
        } else {
            buf.append("UNKNOWN");
        }
        buf.append("\"");
        buf.append(" - ");
        String tempName = Utils.annotationFormFor(method);
        if (!tempName.isEmpty()) {
            buf.append(Utils.annotationFormFor(method)).append(" ");
        }
        buf.append(method.getQualifiedName());
        Class<?>[] objects = Utils.extractParameterTypes(tr.getParameters());
        buf.append("(").append(Utils.stringifyTypes(objects)).append(")");
        return buf.toString();
    }

    public String toString() {
        return "VerboseReporter{suiteName=" + this.suiteName + '}';
    }

    private static enum Status {
        SUCCESS(1),
        FAILURE(2),
        SKIP(3),
        SUCCESS_PERCENTAGE_FAILURE(4),
        STARTED(16);

        private int status;

        private Status(int i2) {
            this.status = i2;
        }
    }
}

