/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;

public class PackageUtils {
    private static final String UTF_8 = "UTF-8";
    private static final String PACKAGE_UTILS = PackageUtils.class.getSimpleName();
    private static String[] testClassPaths;
    private static final Collection<ClassLoader> classLoaders;

    private PackageUtils() {
    }

    public static void addClassLoader(ClassLoader loader) {
        classLoaders.add(loader);
    }

    public static String[] findClassesInPackage(String packageName, List<String> included, List<String> excluded) throws IOException {
        String packageOnly = packageName;
        boolean recursive = false;
        if (packageName.endsWith(".*")) {
            packageOnly = packageName.substring(0, packageName.lastIndexOf(".*"));
            recursive = true;
        }
        List<String> vResult = Lists.newArrayList();
        String packageDirName = packageOnly.replace('.', '/') + (packageOnly.length() > 0 ? "/" : "");
        List<URL> dirs = Lists.newArrayList();
        List<ClassLoader> allClassLoaders = ClassHelper.appendContextualClassLoaders(Lists.newArrayList(classLoaders));
        for (ClassLoader classLoader : allClassLoaders) {
            if (null == classLoader) continue;
            Enumeration<URL> dirEnumeration = classLoader.getResources(packageDirName);
            while (dirEnumeration.hasMoreElements()) {
                URL dir = dirEnumeration.nextElement();
                dirs.add(dir);
            }
        }
        for (URL url : dirs) {
            String protocol = url.getProtocol();
            if (!PackageUtils.matchTestClasspath(url, packageDirName, recursive)) continue;
            if ("file".equals(protocol)) {
                PackageUtils.findClassesInDirPackage(packageOnly, included, excluded, URLDecoder.decode(url.getFile(), UTF_8), recursive, vResult);
                continue;
            }
            if ("jar".equals(protocol)) {
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (name.charAt(0) == '/') {
                        name = name.substring(1);
                    }
                    if (!name.startsWith(packageDirName)) continue;
                    int idx = name.lastIndexOf(47);
                    if (idx != -1) {
                        packageName = name.substring(0, idx).replace('/', '.');
                    }
                    if (!recursive && !packageName.equals(packageOnly)) continue;
                    Utils.log(PACKAGE_UTILS, 4, "Package name is " + packageName);
                    if (!name.endsWith(".class") || entry.isDirectory()) continue;
                    String className = name.substring(packageName.length() + 1, name.length() - 6);
                    Utils.log(PACKAGE_UTILS, 4, "Found class " + className + ", seeing it if it's included or excluded");
                    PackageUtils.includeOrExcludeClass(packageName, className, included, excluded, vResult);
                }
                continue;
            }
            if (!"bundleresource".equals(protocol)) continue;
            try {
                Class[] params = new Class[]{};
                URLConnection connection = url.openConnection();
                Method thisMethod = url.openConnection().getClass().getDeclaredMethod("getFileURL", params);
                Object[] paramsObj = new Object[]{};
                URL fileUrl = (URL)thisMethod.invoke((Object)connection, paramsObj);
                PackageUtils.findClassesInDirPackage(packageOnly, included, excluded, URLDecoder.decode(fileUrl.getFile(), UTF_8), recursive, vResult);
            }
            catch (Exception exception) {
            }
        }
        return vResult.toArray(new String[0]);
    }

    private static String[] getTestClasspath() {
        if (null != testClassPaths) {
            return testClassPaths;
        }
        String testClasspath = RuntimeBehavior.getTestClasspath();
        if (null == testClasspath) {
            return null;
        }
        String[] classpathFragments = Utils.split(testClasspath, File.pathSeparator);
        testClassPaths = new String[classpathFragments.length];
        for (int i2 = 0; i2 < classpathFragments.length; ++i2) {
            String path = classpathFragments[i2].toLowerCase().endsWith(".jar") || classpathFragments[i2].toLowerCase().endsWith(".zip") ? classpathFragments[i2] + "!/" : (classpathFragments[i2].endsWith(File.separator) ? classpathFragments[i2] : classpathFragments[i2] + "/");
            PackageUtils.testClassPaths[i2] = path.replace('\\', '/');
        }
        return testClassPaths;
    }

    private static boolean matchTestClasspath(URL url, String lastFragment, boolean recursive) {
        String[] classpathFragments = PackageUtils.getTestClasspath();
        if (null == classpathFragments) {
            return true;
        }
        String fileName = "";
        try {
            fileName = URLDecoder.decode(url.getFile(), UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        for (String classpathFrag : classpathFragments) {
            String path = classpathFrag + lastFragment;
            int idx = fileName.indexOf(path);
            if (idx == -1 || idx > 0 && fileName.charAt(idx - 1) != '/' || !fileName.endsWith(classpathFrag + lastFragment) && (!recursive || fileName.charAt(idx + path.length()) != '/')) continue;
            return true;
        }
        return false;
    }

    private static void findClassesInDirPackage(String packageName, List<String> included, List<String> excluded, String packagePath, boolean recursive, List<String> classes) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class") || file.getName().endsWith(".groovy"));
        Utils.log(PACKAGE_UTILS, 4, "Looking for test classes in the directory: " + dir);
        if (dirfiles == null) {
            return;
        }
        for (File file2 : dirfiles) {
            if (file2.isDirectory()) {
                PackageUtils.findClassesInDirPackage(PackageUtils.makeFullClassName(packageName, file2.getName()), included, excluded, file2.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().lastIndexOf(46));
            Utils.log(PACKAGE_UTILS, 4, "Found class " + className + ", seeing it if it's included or excluded");
            PackageUtils.includeOrExcludeClass(packageName, className, included, excluded, classes);
        }
    }

    private static String makeFullClassName(String pkg, String cls) {
        return pkg.length() > 0 ? pkg + "." + cls : cls;
    }

    private static void includeOrExcludeClass(String packageName, String className, List<String> included, List<String> excluded, List<String> classes) {
        if (PackageUtils.isIncluded(packageName, included, excluded)) {
            Utils.log(PACKAGE_UTILS, 4, "... Including class " + className);
            classes.add(PackageUtils.makeFullClassName(packageName, className));
        } else {
            Utils.log(PACKAGE_UTILS, 4, "... Excluding class " + className);
        }
    }

    private static boolean isIncluded(String name, List<String> included, List<String> excluded) {
        boolean result;
        if (included.isEmpty() && excluded.isEmpty()) {
            result = true;
        } else {
            boolean isIncluded = PackageUtils.find(name, included);
            boolean isExcluded = PackageUtils.find(name, excluded);
            result = isIncluded && !isExcluded ? true : (isExcluded ? false : included.isEmpty());
        }
        return result;
    }

    private static boolean find(String name, List<String> list) {
        for (String regexpStr : list) {
            if (!Pattern.matches(regexpStr, name)) continue;
            return true;
        }
        return false;
    }

    static {
        classLoaders = new ConcurrentLinkedDeque<ClassLoader>();
    }
}

