/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.concurrent.Callable;
import org.testng.IHookable;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodInvocationHelper;

public class InvokeMethodRunnable
implements Callable<Void> {
    private final ITestNGMethod m_method;
    private final Object m_instance;
    private final Object[] m_parameters;
    private final IHookable m_hookable;
    private final ITestResult m_testResult;

    public InvokeMethodRunnable(ITestNGMethod thisMethod, Object instance, Object[] parameters, IHookable hookable, ITestResult testResult) {
        this.m_method = thisMethod;
        this.m_instance = instance;
        this.m_parameters = parameters;
        this.m_hookable = hookable;
        this.m_testResult = testResult;
    }

    public void run() throws TestNGRuntimeException {
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TestNGRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOne() {
        try {
            TestNGRuntimeException t = null;
            try {
                ConstructorOrMethod m3 = this.m_method.getConstructorOrMethod();
                if (this.m_hookable == null) {
                    MethodInvocationHelper.invokeMethod(m3.getMethod(), this.m_instance, this.m_parameters);
                } else {
                    MethodInvocationHelper.invokeHookable(this.m_instance, this.m_parameters, this.m_hookable, m3.getMethod(), this.m_testResult);
                }
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                t = new TestNGRuntimeException(cause);
            }
            if (null != t) {
                Thread.currentThread().interrupt();
                throw t;
            }
        }
        finally {
            this.m_method.incrementCurrentInvocationCount();
        }
    }

    @Override
    public Void call() throws Exception {
        if (this.m_method.getInvocationTimeOut() > 0L) {
            for (int i2 = 0; i2 < this.m_method.getInvocationCount(); ++i2) {
                this.runOne();
            }
        } else {
            this.runOne();
        }
        return null;
    }

    public static class TestNGRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -8619899270785596231L;

        public TestNGRuntimeException(Throwable rootCause) {
            super(rootCause);
        }
    }
}

