/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.Configuration;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBaseBeforeAfterMethod;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.log4testng.Logger;

public class ConfigurationMethod
extends BaseTestMethod {
    private final boolean m_isBeforeSuiteConfiguration;
    private final boolean m_isAfterSuiteConfiguration;
    private final boolean m_isBeforeTestConfiguration;
    private final boolean m_isAfterTestConfiguration;
    private final boolean m_isBeforeClassConfiguration;
    private final boolean m_isAfterClassConfiguration;
    private final boolean m_isBeforeMethodConfiguration;
    private final boolean m_isAfterMethodConfiguration;
    private boolean m_isBeforeGroupsConfiguration;
    private boolean m_isAfterGroupsConfiguration;
    private boolean m_inheritGroupsFromTestClass = false;

    private ConfigurationMethod(ConstructorOrMethod com, IAnnotationFinder annotationFinder, boolean isBeforeSuite, boolean isAfterSuite, boolean isBeforeTest, boolean isAfterTest, boolean isBeforeClass, boolean isAfterClass, boolean isBeforeMethod, boolean isAfterMethod, String[] beforeGroups, String[] afterGroups, boolean initialize, Object instance) {
        super(com.getName(), com, annotationFinder, instance);
        if (initialize) {
            this.init();
        }
        this.m_isBeforeSuiteConfiguration = isBeforeSuite;
        this.m_isAfterSuiteConfiguration = isAfterSuite;
        this.m_isBeforeTestConfiguration = isBeforeTest;
        this.m_isAfterTestConfiguration = isAfterTest;
        this.m_isBeforeClassConfiguration = isBeforeClass;
        this.m_isAfterClassConfiguration = isAfterClass;
        this.m_isBeforeMethodConfiguration = isBeforeMethod;
        this.m_isAfterMethodConfiguration = isAfterMethod;
        this.m_beforeGroups = beforeGroups;
        this.m_afterGroups = afterGroups;
    }

    public ConfigurationMethod(ConstructorOrMethod com, IAnnotationFinder annotationFinder, boolean isBeforeSuite, boolean isAfterSuite, boolean isBeforeTest, boolean isAfterTest, boolean isBeforeClass, boolean isAfterClass, boolean isBeforeMethod, boolean isAfterMethod, String[] beforeGroups, String[] afterGroups, Object instance) {
        this(com, annotationFinder, isBeforeSuite, isAfterSuite, isBeforeTest, isAfterTest, isBeforeClass, isAfterClass, isBeforeMethod, isAfterMethod, beforeGroups, afterGroups, true, instance);
    }

    private static ITestNGMethod[] createMethods(ITestNGMethod[] methods, IAnnotationFinder finder, boolean isBeforeSuite, boolean isAfterSuite, boolean isBeforeTest, boolean isAfterTest, boolean isBeforeClass, boolean isAfterClass, boolean isBeforeMethod, boolean isAfterMethod, Object instance) {
        List result = Lists.newArrayList();
        for (ITestNGMethod method : methods) {
            if (Modifier.isStatic(method.getConstructorOrMethod().getMethod().getModifiers())) {
                String msg = "Detected a static method [" + method.getQualifiedName() + "()]. Static configuration methods can cause  unexpected behavior.";
                Logger.getLogger(Configuration.class).warn(msg);
            }
            result.add(new ConfigurationMethod(method.getConstructorOrMethod(), finder, isBeforeSuite, isAfterSuite, isBeforeTest, isAfterTest, isBeforeClass, isAfterClass, isBeforeMethod, isAfterMethod, new String[0], new String[0], instance));
        }
        return result.toArray(new ITestNGMethod[0]);
    }

    public static ITestNGMethod[] createSuiteConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore, Object instance) {
        return ConfigurationMethod.createMethods(methods, annotationFinder, isBefore, !isBefore, false, false, false, false, false, false, instance);
    }

    public static ITestNGMethod[] createTestConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore, Object instance) {
        return ConfigurationMethod.createMethods(methods, annotationFinder, false, false, isBefore, !isBefore, false, false, false, false, instance);
    }

    public static ITestNGMethod[] createClassConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore, Object instance) {
        return ConfigurationMethod.createMethods(methods, annotationFinder, false, false, false, false, isBefore, !isBefore, false, false, instance);
    }

    public static ITestNGMethod[] createBeforeConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore, Object instance) {
        ITestNGMethod[] result = new ITestNGMethod[methods.length];
        for (int i2 = 0; i2 < methods.length; ++i2) {
            result[i2] = new ConfigurationMethod(methods[i2].getConstructorOrMethod(), annotationFinder, false, false, false, false, false, false, false, false, isBefore ? methods[i2].getBeforeGroups() : new String[]{}, new String[0], instance);
        }
        return result;
    }

    public static ITestNGMethod[] createAfterConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore, Object instance) {
        return (ITestNGMethod[])((Stream)Arrays.stream(methods).parallel()).map(m3 -> new ConfigurationMethod(m3.getConstructorOrMethod(), annotationFinder, false, false, false, false, false, false, false, false, new String[]{}, isBefore ? m3.getBeforeGroups() : m3.getAfterGroups(), instance)).toArray(ITestNGMethod[]::new);
    }

    public static ITestNGMethod[] createTestMethodConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore, Object instance) {
        return ConfigurationMethod.createMethods(methods, annotationFinder, false, false, false, false, false, false, isBefore, !isBefore, instance);
    }

    @Override
    public boolean isAfterClassConfiguration() {
        return this.m_isAfterClassConfiguration;
    }

    @Override
    public boolean isAfterMethodConfiguration() {
        return this.m_isAfterMethodConfiguration;
    }

    @Override
    public boolean isBeforeClassConfiguration() {
        return this.m_isBeforeClassConfiguration;
    }

    @Override
    public boolean isBeforeMethodConfiguration() {
        return this.m_isBeforeMethodConfiguration;
    }

    @Override
    public boolean isAfterSuiteConfiguration() {
        return this.m_isAfterSuiteConfiguration;
    }

    @Override
    public boolean isBeforeSuiteConfiguration() {
        return this.m_isBeforeSuiteConfiguration;
    }

    @Override
    public boolean isBeforeTestConfiguration() {
        return this.m_isBeforeTestConfiguration;
    }

    @Override
    public boolean isAfterTestConfiguration() {
        return this.m_isAfterTestConfiguration;
    }

    @Override
    public boolean isBeforeGroupsConfiguration() {
        return this.m_beforeGroups != null && this.m_beforeGroups.length > 0;
    }

    @Override
    public boolean hasBeforeGroupsConfiguration() {
        return this.m_isBeforeGroupsConfiguration;
    }

    @Override
    public boolean hasAfterGroupsConfiguration() {
        return this.m_isAfterGroupsConfiguration;
    }

    @Override
    public boolean isAfterGroupsConfiguration() {
        return this.m_afterGroups != null && this.m_afterGroups.length > 0;
    }

    private boolean inheritGroupsFromTestClass() {
        return this.m_inheritGroupsFromTestClass;
    }

    private void init() {
        ITestAnnotation classAnnotation;
        IConfigurationAnnotation annotation = AnnotationHelper.findConfiguration(this.m_annotationFinder, this.m_method.getMethod());
        if (annotation != null) {
            this.m_inheritGroupsFromTestClass = annotation.getInheritGroups();
            this.setEnabled(annotation.getEnabled());
            this.setDescription(annotation.getDescription());
        }
        if (annotation != null && annotation.isFakeConfiguration()) {
            if (annotation.getBeforeSuite()) {
                this.initGroups(IBeforeSuite.class);
            }
            if (annotation.getAfterSuite()) {
                this.initGroups(IAfterSuite.class);
            }
            if (annotation.getBeforeTest()) {
                this.initGroups(IBeforeTest.class);
            }
            if (annotation.getAfterTest()) {
                this.initGroups(IAfterTest.class);
            }
            this.m_isBeforeGroupsConfiguration = annotation.isBeforeGroups();
            this.m_isAfterGroupsConfiguration = annotation.isAfterGroups();
            if (annotation.getBeforeGroups().length != 0) {
                this.initBeforeAfterGroups(IBeforeGroups.class, annotation.getBeforeGroups());
            }
            if (annotation.getAfterGroups().length != 0) {
                this.initBeforeAfterGroups(IAfterGroups.class, annotation.getAfterGroups());
            }
            if (annotation.getBeforeTestClass()) {
                this.initGroups(IBeforeClass.class);
            }
            if (annotation.getAfterTestClass()) {
                this.initGroups(IAfterClass.class);
            }
            if (annotation.getBeforeTestMethod()) {
                this.initGroups(IBeforeMethod.class);
            }
            if (annotation.getAfterTestMethod()) {
                this.initGroups(IAfterMethod.class);
            }
        } else {
            this.initGroups(IConfigurationAnnotation.class);
        }
        if (this.inheritGroupsFromTestClass() && (classAnnotation = this.m_annotationFinder.findAnnotation(this.m_methodClass, ITestAnnotation.class)) != null) {
            String[] groups = classAnnotation.getGroups();
            Map<String, String> newGroups = Maps.newHashMap();
            for (String g2 : this.getGroups()) {
                newGroups.put(g2, g2);
            }
            if (groups != null) {
                for (String g2 : groups) {
                    newGroups.put(g2, g2);
                }
                this.setGroups(newGroups.values().toArray(new String[0]));
            }
        }
        if (annotation != null) {
            this.setTimeOut(annotation.getTimeOut());
        }
    }

    @Override
    public ConfigurationMethod clone() {
        ConfigurationMethod clone = new ConfigurationMethod(this.getConstructorOrMethod(), this.getAnnotationFinder(), this.isBeforeSuiteConfiguration(), this.isAfterSuiteConfiguration(), this.isBeforeTestConfiguration(), this.isAfterTestConfiguration(), this.isBeforeClassConfiguration(), this.isAfterClassConfiguration(), this.isBeforeMethodConfiguration(), this.isAfterMethodConfiguration(), this.getBeforeGroups(), this.getAfterGroups(), false, this.getInstance());
        clone.m_testClass = this.getTestClass();
        clone.setDate(this.getDate());
        clone.setGroups(this.getGroups());
        clone.setGroupsDependedUpon(this.getGroupsDependedUpon(), Collections.emptyList());
        clone.setMethodsDependedUpon(this.getMethodsDependedUpon());
        clone.setAlwaysRun(this.isAlwaysRun());
        clone.setMissingGroup(this.getMissingGroup());
        clone.setDescription(this.getDescription());
        clone.setEnabled(this.getEnabled());
        clone.setParameterInvocationCount(this.getParameterInvocationCount());
        clone.m_inheritGroupsFromTestClass = this.inheritGroupsFromTestClass();
        return clone;
    }

    public boolean isFirstTimeOnly() {
        boolean result = false;
        IBeforeMethod before = this.m_annotationFinder.findAnnotation(this.getConstructorOrMethod(), IBeforeMethod.class);
        if (before != null) {
            result = ((ConfigurationAnnotation)before).isFirstTimeOnly();
        }
        return result;
    }

    public boolean isLastTimeOnly() {
        boolean result = false;
        IAfterMethod before = this.m_annotationFinder.findAnnotation(this.getConstructorOrMethod(), IAfterMethod.class);
        if (before != null) {
            result = ((ConfigurationAnnotation)before).isLastTimeOnly();
        }
        return result;
    }

    public String[] getGroupFilters() {
        IBaseBeforeAfterMethod beforeAfter = this.m_annotationFinder.findAnnotation(this.getConstructorOrMethod(), IBeforeMethod.class);
        if (beforeAfter == null) {
            beforeAfter = this.m_annotationFinder.findAnnotation(this.getConstructorOrMethod(), IAfterMethod.class);
        }
        if (beforeAfter == null) {
            return new String[0];
        }
        return beforeAfter.getGroupFilters();
    }
}

