/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.testng.ITestResult;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.util.Strings;

public class Reporter {
    private static final ThreadLocal<ITestResult> m_currentTestResult = new InheritableThreadLocal<ITestResult>();
    private static final List<String> m_output = new Vector<String>();
    private static final Map<Integer, List<Integer>> m_methodOutputMap = Maps.newHashMap();
    private static boolean m_escapeHtml = false;
    private static final ThreadLocal<List<String>> m_orphanedOutput = new InheritableThreadLocal<List<String>>();

    public static void setCurrentTestResult(ITestResult m3) {
        m_currentTestResult.set(m3);
    }

    public static List<String> getOutput() {
        return m_output;
    }

    public static void clear() {
        m_methodOutputMap.clear();
        m_output.clear();
    }

    public static boolean getEscapeHtml() {
        return m_escapeHtml;
    }

    public static void setEscapeHtml(boolean escapeHtml) {
        m_escapeHtml = escapeHtml;
    }

    private static synchronized void log(String s2, ITestResult m3) {
        if (m_escapeHtml) {
            s2 = Strings.escapeHtml(s2);
        }
        if (m3 == null) {
            if (m_orphanedOutput.get() == null) {
                m_orphanedOutput.set(new ArrayList());
            }
            m_orphanedOutput.get().add(s2);
            return;
        }
        int n = Reporter.getOutput().size();
        List lines = m_methodOutputMap.computeIfAbsent(m3.hashCode(), k -> Lists.newArrayList());
        if (m_orphanedOutput.get() != null) {
            n += m_orphanedOutput.get().size();
            Reporter.getOutput().addAll((Collection<String>)m_orphanedOutput.get());
            m_orphanedOutput.remove();
        }
        lines.add(n);
        Reporter.getOutput().add(s2);
    }

    public static void log(String s2) {
        Reporter.log(s2, Reporter.getCurrentTestResult());
    }

    public static void log(String s2, int level, boolean logToStandardOut) {
        if (TestRunner.getVerbose() >= level) {
            Reporter.log(s2, Reporter.getCurrentTestResult());
            if (logToStandardOut) {
                System.out.println(s2);
            }
        }
    }

    public static void log(String s2, boolean logToStandardOut) {
        Reporter.log(s2, Reporter.getCurrentTestResult());
        if (logToStandardOut) {
            System.out.println(s2);
        }
    }

    public static void log(String s2, int level) {
        if (TestRunner.getVerbose() >= level) {
            Reporter.log(s2, Reporter.getCurrentTestResult());
        }
    }

    public static ITestResult getCurrentTestResult() {
        return m_currentTestResult.get();
    }

    public static synchronized List<String> getOutput(ITestResult tr) {
        List<String> result = Lists.newArrayList();
        if (tr == null) {
            return result;
        }
        List<Integer> lines = m_methodOutputMap.get(tr.hashCode());
        if (lines != null) {
            for (Integer n : lines) {
                result.add(Reporter.getOutput().get(n));
            }
        }
        return result;
    }
}

