/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.testng.IClass;
import org.testng.IInjectorFactory;
import org.testng.IModule;
import org.testng.IModuleFactory;
import org.testng.ITestContext;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.annotations.Guice;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassImpl;
import org.testng.internal.InstanceCreator;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;

@Deprecated
public class GuiceHelper {
    private final ITestContext context;
    private static final BiPredicate<Module, Module> CLASS_EQUALITY = (m3, n) -> m3.getClass().equals(n.getClass());

    GuiceHelper(ITestContext context) {
        this.context = context;
    }

    Injector getInjector(IClass iClass, IInjectorFactory injectorFactory) {
        Guice guice = AnnotationHelper.findAnnotationSuperClasses(Guice.class, iClass.getRealClass());
        if (guice == null) {
            return null;
        }
        if (iClass instanceof TestClass) {
            iClass = ((TestClass)iClass).getIClass();
        }
        if (!(iClass instanceof ClassImpl)) {
            return null;
        }
        Injector parentInjector = ((ClassImpl)iClass).getParentInjector(injectorFactory);
        List<Module> classLevelModules = this.getModules(guice, parentInjector, iClass.getRealClass());
        Injector injector = this.context.getInjector(classLevelModules);
        if (injector == null) {
            injector = GuiceHelper.createInjector(parentInjector, this.context, injectorFactory, classLevelModules);
            this.context.addInjector(classLevelModules, injector);
        }
        return injector;
    }

    public static Module getParentModule(ITestContext context) {
        Module obj;
        Class<? extends Module> parentModule = GuiceHelper.getParentModuleClass(context);
        if (parentModule == null) {
            return null;
        }
        List<Module> allModules = context.getGuiceModules(parentModule);
        if (!allModules.isEmpty()) {
            if (allModules.size() > 1) {
                throw new IllegalStateException("Found more than 1 module associated with the test <" + context.getName() + ">");
            }
            return allModules.get(0);
        }
        try {
            Constructor<? extends Module> moduleConstructor = parentModule.getDeclaredConstructor(ITestContext.class);
            obj = InstanceCreator.newInstance(moduleConstructor, context);
        }
        catch (NoSuchMethodException e) {
            obj = InstanceCreator.newInstance(parentModule);
        }
        context.addGuiceModule(obj);
        return obj;
    }

    private static Class<? extends Module> getParentModuleClass(ITestContext context) {
        if (Utils.isStringEmpty(context.getSuite().getParentModule())) {
            return null;
        }
        Class<?> parentModule = ClassHelper.forName(context.getSuite().getParentModule());
        if (parentModule == null) {
            throw new TestNGException("Cannot load parent Guice module class: " + context.getSuite().getParentModule());
        }
        if (!Module.class.isAssignableFrom(parentModule)) {
            throw new TestNGException("Provided class is not a Guice module: " + parentModule.getName());
        }
        return parentModule;
    }

    public static Injector createInjector(Injector parent, ITestContext context, IInjectorFactory injectorFactory, List<Module> moduleInstances) {
        Stage stage = Stage.DEVELOPMENT;
        String stageString = context.getSuite().getGuiceStage();
        if (Utils.isStringNotEmpty(stageString)) {
            stage = Stage.valueOf((String)stageString);
        }
        moduleInstances.forEach(context::addGuiceModule);
        Module[] modules = moduleInstances.toArray(new Module[0]);
        if (parent == null || GuiceHelper.getParentModuleClass(context) == null) {
            return injectorFactory.getInjector(null, stage, modules);
        }
        return injectorFactory.getInjector(parent, stage, modules);
    }

    private List<Module> getModules(Guice guice, Injector parentInjector, Class<?> testClass) {
        IModuleFactory factoryInstance;
        Module module;
        List<Module> result = Lists.newArrayList();
        for (Class<? extends Module> moduleClass : guice.modules()) {
            List<Module> modules = this.context.getGuiceModules(moduleClass);
            if (modules != null && !modules.isEmpty()) {
                result.addAll(modules);
                result = Lists.merge(result, CLASS_EQUALITY, modules);
                continue;
            }
            Module instance = (Module)parentInjector.getInstance(moduleClass);
            result = Lists.merge(result, CLASS_EQUALITY, Collections.singletonList(instance));
            this.context.addGuiceModule(instance);
        }
        Class<? extends IModuleFactory> factory = guice.moduleFactory();
        if (factory != IModuleFactory.class && (module = (factoryInstance = (IModuleFactory)parentInjector.getInstance(factory)).createModule(this.context, testClass)) != null) {
            result = Lists.merge(result, CLASS_EQUALITY, Collections.singletonList(module));
        }
        result = Lists.merge(result, CLASS_EQUALITY, LazyHolder.getSpiModules());
        return result;
    }

    private static final class LazyHolder {
        private static final List<Module> spiModules = LazyHolder.loadModules();

        private LazyHolder() {
        }

        private static List<Module> loadModules() {
            return StreamSupport.stream(ServiceLoader.load(IModule.class).spliterator(), false).map(IModule::getModule).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }

        public static List<Module> getSpiModules() {
            return spiModules;
        }
    }
}

