/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.OutputStream;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirror;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter;

public final class JUnitTaskMirrorImpl
implements JUnitTaskMirror {
    private final JUnitTask task;

    public JUnitTaskMirrorImpl(JUnitTask task) {
        this.task = task;
    }

    @Override
    public void addVmExit(JUnitTest test, JUnitTaskMirror.JUnitResultFormatterMirror aFormatter, OutputStream out, String message, String testCase) {
        JUnitResultFormatter formatter = (JUnitResultFormatter)aFormatter;
        formatter.setOutput(out);
        formatter.startTestSuite(test);
        VmExitErrorTest t = new VmExitErrorTest(message, test, testCase);
        formatter.startTest(t);
        formatter.addError(t, (Throwable)((Object)new AssertionFailedError(message)));
        formatter.endTestSuite(test);
    }

    @Override
    public JUnitTaskMirror.JUnitTestRunnerMirror newJUnitTestRunner(JUnitTest test, String[] methods, boolean haltOnError, boolean filterTrace, boolean haltOnFailure, boolean showOutput, boolean logTestListenerEvents, AntClassLoader classLoader) {
        return new JUnitTestRunner(test, methods, haltOnError, filterTrace, haltOnFailure, showOutput, logTestListenerEvents, classLoader);
    }

    @Override
    public JUnitTaskMirror.SummaryJUnitResultFormatterMirror newSummaryJUnitResultFormatter() {
        return new SummaryJUnitResultFormatter();
    }

    static class VmExitErrorTest
    extends TestCase {
        private String message;
        private JUnitTest test;
        private String testCase;

        VmExitErrorTest(String aMessage, JUnitTest anOriginalTest, String aTestCase) {
            this.message = aMessage;
            this.test = anOriginalTest;
            this.testCase = aTestCase;
        }

        @Override
        public int countTestCases() {
            return 1;
        }

        @Override
        public void run(TestResult r) {
            throw new AssertionFailedError(this.message);
        }

        @Override
        public String getName() {
            return this.testCase;
        }

        String getClassName() {
            return this.test.getName();
        }

        @Override
        public String toString() {
            return this.test.getName() + ":" + this.testCase;
        }
    }
}

