/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr.build;

import groovyjarjarantlr.build.Tool;
import java.io.File;
import java.io.FilenameFilter;

public class ANTLR {
    public static String compiler = "javac";
    public static String jarName = "groovyjarjarantlr.jar";
    public static String root = ".";
    public static String[] srcdir = new String[]{"antlr", "groovyjarjarantlr/actions/cpp", "groovyjarjarantlr/actions/java", "groovyjarjarantlr/actions/csharp", "groovyjarjarantlr/collections", "groovyjarjarantlr/collections/impl", "groovyjarjarantlr/debug", "groovyjarjarantlr/ASdebug", "groovyjarjarantlr/debug/misc", "groovyjarjarantlr/preprocessor"};

    public ANTLR() {
        compiler = System.getProperty("groovyjarjarantlr.build.compiler", compiler);
        root = System.getProperty("groovyjarjarantlr.build.root", root);
    }

    public String getName() {
        return "ANTLR";
    }

    public void build(Tool tool) {
        if (!this.rootIsValidANTLRDir(tool)) {
            return;
        }
        tool.antlr(root + "/groovyjarjarantlr/antlr.g");
        tool.antlr(root + "/groovyjarjarantlr/tokdef.g");
        tool.antlr(root + "/groovyjarjarantlr/preprocessor/preproc.g");
        tool.antlr(root + "/groovyjarjarantlr/actions/java/action.g");
        tool.antlr(root + "/groovyjarjarantlr/actions/cpp/action.g");
        tool.antlr(root + "/groovyjarjarantlr/actions/csharp/action.g");
        for (int j = 0; j < srcdir.length; ++j) {
            String string = compiler + " -d " + root + " " + root + "/" + srcdir[j] + "/*.java";
            tool.system(string);
        }
    }

    public void jar(Tool tool) {
        if (!this.rootIsValidANTLRDir(tool)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("jar cvf " + root + "/" + jarName);
        for (int j = 0; j < srcdir.length; ++j) {
            stringBuffer.append(" " + root + "/" + srcdir[j] + "/*.class");
        }
        tool.system(stringBuffer.toString());
    }

    protected boolean rootIsValidANTLRDir(Tool tool) {
        if (root == null) {
            return false;
        }
        File file = new File(root);
        if (!file.exists()) {
            tool.error("Property antlr.build.root==" + root + " does not exist");
            return false;
        }
        if (!file.isDirectory()) {
            tool.error("Property antlr.build.root==" + root + " is not a directory");
            return false;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return file.isDirectory() && string.equals("antlr");
            }
        });
        if (stringArray == null || stringArray.length == 0) {
            tool.error("Property antlr.build.root==" + root + " does not appear to be a valid ANTLR project root (no antlr subdir)");
            return false;
        }
        File file2 = new File(root + "/antlr");
        String[] stringArray2 = file2.list();
        if (stringArray2 == null || stringArray2.length == 0) {
            tool.error("Property antlr.build.root==" + root + " does not appear to be a valid ANTLR project root (no .java files in antlr subdir");
            return false;
        }
        return true;
    }
}

