/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.annotation.AnnotationValue;
import com.thoughtworks.qdox.model.annotation.AnnotationVisitor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Annotation
implements AnnotationValue,
Serializable {
    private final Type type;
    private final int lineNumber;
    private final Map properties = new LinkedHashMap();
    private final Map namedParameters = new LinkedHashMap();
    private AbstractBaseJavaEntity context;

    public Annotation(Type type, AbstractBaseJavaEntity context, Map namedParameters, int lineNumber) {
        this.type = type;
        this.context = context;
        this.lineNumber = lineNumber;
        if (this.properties != null) {
            Iterator i2 = this.properties.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                String name = (String)entry.getKey();
                AnnotationValue value = (AnnotationValue)entry.getValue();
                this.setProperty(name, value);
            }
        }
    }

    public Annotation(Type type, int line) {
        this(type, null, null, line);
    }

    public void setProperty(String name, AnnotationValue value) {
        this.properties.put(name, value);
        this.namedParameters.put(name, value.getParameterValue());
    }

    public Type getType() {
        return this.type;
    }

    public Object getNamedParameter(String key) {
        return this.namedParameters.get(key);
    }

    public Map getNamedParameterMap() {
        return this.namedParameters;
    }

    public final AbstractBaseJavaEntity getContext() {
        return this.context;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Object accept(AnnotationVisitor visitor) {
        return visitor.visitAnnotation(this);
    }

    public Object getParameterValue() {
        return this;
    }

    public Map getPropertyMap() {
        return this.properties;
    }

    public AnnotationValue getProperty(String name) {
        return (AnnotationValue)this.properties.get(name);
    }

    public void setContext(AbstractBaseJavaEntity context) {
        this.context = context;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('@');
        result.append(this.type.getValue());
        result.append('(');
        if (!this.namedParameters.isEmpty()) {
            Iterator i2 = this.namedParameters.entrySet().iterator();
            while (i2.hasNext()) {
                result.append(i2.next() + ",");
            }
            result.deleteCharAt(result.length() - 1);
        }
        result.append(')');
        return result.toString();
    }
}

