/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.testng.internal.reflect.AbstractNodeMethodMatcher;
import org.testng.internal.reflect.InjectableParameter;
import org.testng.internal.reflect.MethodMatcherContext;
import org.testng.internal.reflect.Parameter;
import org.testng.internal.reflect.ReflectionRecipes;

public class ArrayEndingMethodMatcher
extends AbstractNodeMethodMatcher {
    public ArrayEndingMethodMatcher(MethodMatcherContext context) {
        super(context);
    }

    @Override
    protected List<Set<InjectableParameter>> getConformanceInjectsOrder() {
        ArrayList<Set<InjectableParameter>> injectsOrder = new ArrayList<Set<InjectableParameter>>(1);
        injectsOrder.add(InjectableParameter.Assistant.ALL_INJECTS);
        return injectsOrder;
    }

    @Override
    protected boolean match(Parameter[] parameters, Object[] arguments) {
        return ReflectionRecipes.matchArrayEnding(parameters, this.getContext().getArguments());
    }

    @Override
    protected Object[] matchingArguments(Parameter[] parameters, Object[] arguments) {
        Class<?>[] classes = ReflectionRecipes.classesFromParameters(parameters);
        Object[] objects = new Object[classes.length];
        Class<?> componentType = classes[classes.length - 1].getComponentType();
        Object array = Array.newInstance(componentType, arguments.length - classes.length + 1);
        System.arraycopy(arguments, 0, objects, 0, classes.length - 1);
        int j = 0;
        int i2 = classes.length - 1;
        while (i2 < arguments.length) {
            Array.set(array, j, arguments[i2]);
            ++i2;
            ++j;
        }
        objects[classes.length - 1] = array;
        return objects;
    }
}

