/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.Attributes;
import org.testng.internal.IParameterInfo;
import org.testng.internal.LiteWeightTestNGMethod;
import org.testng.internal.RuntimeBehavior;

public class TestResult
implements ITestResult {
    private ITestNGMethod m_method = null;
    private List<ITestNGMethod> skippedDueTo = Lists.newArrayList();
    private boolean skipAnalysed = false;
    private int m_status = -1;
    private Throwable m_throwable = null;
    private long m_startMillis = 0L;
    private long m_endMillis = 0L;
    private String m_name = null;
    private String m_host;
    private Object[] m_parameters = new Object[0];
    private String m_instanceName;
    private ITestContext m_context;
    private int parameterIndex;
    private boolean m_wasRetried;
    private final IAttributes m_attributes = new Attributes();

    private TestResult() {
    }

    public static TestResult newEmptyTestResult() {
        return new TestResult();
    }

    public static TestResult newTestResultFor(ITestNGMethod method) {
        return TestResult.newContextAwareTestResult(method, null);
    }

    public static TestResult newContextAwareTestResult(ITestNGMethod method, ITestContext ctx) {
        TestResult result = TestResult.newEmptyTestResult();
        long time = System.currentTimeMillis();
        result.init(method, ctx, null, time, 0L);
        return result;
    }

    public static TestResult newTestResultWithCauseAs(ITestNGMethod method, ITestContext ctx, Throwable t) {
        TestResult result = TestResult.newEmptyTestResult();
        long time = System.currentTimeMillis();
        result.init(method, ctx, t, time, time);
        return result;
    }

    public static TestResult newEndTimeAwareTestResult(ITestNGMethod method, ITestContext ctx, Throwable t, long start) {
        TestResult result = TestResult.newEmptyTestResult();
        long time = System.currentTimeMillis();
        result.init(method, ctx, t, start, time);
        return result;
    }

    public static TestResult newTestResultFrom(TestResult result, ITestNGMethod method, ITestContext ctx, long start) {
        TestResult testResult = TestResult.newEmptyTestResult();
        testResult.setHost(result.getHost());
        testResult.setParameters(result.getParameters());
        testResult.setParameterIndex(result.getParameterIndex());
        testResult.init(method, ctx, null, start, 0L);
        TestResult.copyAttributes(result, testResult);
        return testResult;
    }

    private void init(ITestNGMethod method, ITestContext ctx, Throwable t, long start, long end) {
        this.m_throwable = t;
        this.m_instanceName = method.getTestClass().getName();
        if (null == this.m_throwable) {
            this.m_status = 1;
        }
        this.m_startMillis = start;
        this.m_endMillis = end;
        this.m_method = RuntimeBehavior.isMemoryFriendlyMode() ? new LiteWeightTestNGMethod(method) : method;
        this.m_context = ctx;
        Object instance = method.getInstance();
        if (instance == null) {
            this.m_name = this.m_method.getMethodName();
            return;
        }
        if (instance instanceof ITest) {
            this.m_name = ((ITest)instance).getTestName();
            if (this.m_name != null) {
                return;
            }
            this.m_name = this.m_method.getMethodName();
            if (TestRunner.getVerbose() > 1) {
                String msg = String.format("Warning: [%s] implementation on class [%s] returned null. Defaulting to method name", ITest.class.getName(), instance.getClass().getName());
                System.err.println(msg);
            }
            return;
        }
        if (method.getTestClass().getTestName() != null) {
            this.m_name = method.getTestClass().getTestName();
            return;
        }
        String string = instance.toString();
        this.m_name = this.getMethod().getMethodName();
        try {
            if (!Object.class.getMethod("toString", new Class[0]).equals(instance.getClass().getMethod("toString", new Class[0]))) {
                this.m_instanceName = string.startsWith("class ") ? string.substring("class ".length()) : string;
                this.m_name = this.m_name + " on " + this.m_instanceName;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public void setEndMillis(long millis) {
        this.m_endMillis = millis;
    }

    @Override
    public String getTestName() {
        if (this.m_method == null) {
            return null;
        }
        Object instance = this.m_method.getInstance();
        if (instance instanceof ITest) {
            return ((ITest)instance).getTestName();
        }
        if (this.m_method.getTestClass().getTestName() != null) {
            return this.m_method.getTestClass().getTestName();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    public void setMethod(ITestNGMethod method) {
        this.m_method = method;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public boolean isSuccess() {
        return 1 == this.m_status;
    }

    @Override
    public IClass getTestClass() {
        return this.m_method.getTestClass();
    }

    @Override
    public Throwable getThrowable() {
        return this.m_throwable;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        this.m_throwable = throwable;
    }

    @Override
    public long getEndMillis() {
        return this.m_endMillis;
    }

    @Override
    public long getStartMillis() {
        return this.m_startMillis;
    }

    public String toString() {
        List<String> output = Reporter.getOutput(this);
        return Objects.toStringHelper(this.getClass()).omitNulls().omitEmptyStrings().add("name", this.getName()).add("status", TestResult.toString(this.m_status)).add("method", this.m_method).add("output", output != null && output.size() > 0 ? output.get(0) : null).toString();
    }

    private static String toString(int status) {
        switch (status) {
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "FAILURE";
            }
            case 3: {
                return "SKIP";
            }
            case 4: {
                return "SUCCESS WITHIN PERCENTAGE";
            }
            case 16: {
                return "STARTED";
            }
            case -1: {
                return "CREATED";
            }
        }
        throw new TestNGException("Encountered an un-defined test status of [" + status + "].");
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public Object[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public void setParameters(Object[] parameters) {
        this.m_parameters = new Object[parameters.length];
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (parameters[i2] instanceof Cloneable) {
                try {
                    Method clone = parameters[i2].getClass().getDeclaredMethod("clone", new Class[0]);
                    this.m_parameters[i2] = clone.invoke(parameters[i2], new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    this.m_parameters[i2] = parameters[i2];
                }
                continue;
            }
            this.m_parameters[i2] = parameters[i2];
        }
    }

    @Override
    public Object getInstance() {
        return IParameterInfo.embeddedInstance(this.m_method.getInstance());
    }

    @Override
    public Object[] getFactoryParameters() {
        IParameterInfo instance = this.m_method.getFactoryMethodParamsInfo();
        if (instance != null) {
            return instance.getParameters();
        }
        return new Object[0];
    }

    @Override
    public Object getAttribute(String name) {
        return this.m_attributes.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.m_attributes.removeAttribute(name);
    }

    @Override
    public ITestContext getTestContext() {
        return this.m_context;
    }

    public void setContext(ITestContext context) {
        this.m_context = context;
    }

    @Override
    public int compareTo(@Nonnull ITestResult comparison) {
        return Long.compare(this.getStartMillis(), comparison.getStartMillis());
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    @Override
    public void setTestName(String name) {
        this.m_name = name;
    }

    void setParameterIndex(int parameterIndex) {
        this.parameterIndex = parameterIndex;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Override
    public boolean wasRetried() {
        return this.m_wasRetried;
    }

    @Override
    public void setWasRetried(boolean wasRetried) {
        this.m_wasRetried = wasRetried;
    }

    @Override
    public List<ITestNGMethod> getSkipCausedBy() {
        if (this.m_status != 3 || this.skipAnalysed) {
            return Collections.unmodifiableList(this.skippedDueTo);
        }
        this.skipAnalysed = true;
        Set<ITestResult> skippedConfigs = this.m_context.getFailedConfigurations().getAllResults();
        for (ITestResult skippedConfig : skippedConfigs) {
            if (TestResult.isGlobalFailure(skippedConfig) || this.isRelated(skippedConfig)) {
                this.skippedDueTo.add(skippedConfig.getMethod());
            }
            if (!this.belongToSameGroup(skippedConfig)) continue;
            this.skippedDueTo.add(skippedConfig.getMethod());
        }
        if (!this.skippedDueTo.isEmpty()) {
            return Collections.unmodifiableList(this.skippedDueTo);
        }
        if (this.m_method.getMethodsDependedUpon().length == 0) {
            if (this.m_method.getGroupsDependedUpon().length == 0) {
                return Collections.emptyList();
            }
            List<String> upstreamGroups = Arrays.asList(this.m_method.getGroupsDependedUpon());
            List<ITestResult> allFailures = Lists.merge(this.m_context.getFailedTests().getAllResults(), this.m_context.getFailedButWithinSuccessPercentageTests().getAllResults());
            this.skippedDueTo = allFailures.stream().map(ITestResult::getMethod).filter(method -> {
                List<String> currentMethodGroups = Arrays.asList(method.getGroups());
                List<String> interection = Lists.intersection(upstreamGroups, currentMethodGroups);
                return !interection.isEmpty();
            }).collect(Collectors.toList());
            return Collections.unmodifiableList(this.skippedDueTo);
        }
        List<String> upstreamMethods = Arrays.asList(this.m_method.getMethodsDependedUpon());
        List<ITestResult> allfailures = Lists.merge(this.m_context.getFailedTests().getAllResults(), this.m_context.getFailedButWithinSuccessPercentageTests().getAllResults());
        this.skippedDueTo = allfailures.stream().map(ITestResult::getMethod).filter(method -> upstreamMethods.contains(method.getQualifiedName())).collect(Collectors.toList());
        return Collections.unmodifiableList(this.skippedDueTo);
    }

    private static boolean isGlobalFailure(ITestResult result) {
        ITestNGMethod m3 = result.getMethod();
        return m3.isBeforeTestConfiguration() || m3.isBeforeSuiteConfiguration();
    }

    private boolean isRelated(ITestResult result) {
        ITestNGMethod m3 = result.getMethod();
        if (!m3.isBeforeClassConfiguration() && !m3.isBeforeMethodConfiguration()) {
            return false;
        }
        Object current = this.getInstance();
        Object thatObject = result.getInstance();
        return current.getClass().isAssignableFrom(thatObject.getClass()) || thatObject.getClass().isAssignableFrom(current.getClass());
    }

    private boolean belongToSameGroup(ITestResult result) {
        ITestNGMethod m3 = result.getMethod();
        if (!m3.isBeforeGroupsConfiguration()) {
            return false;
        }
        String[] mygroups = this.m_method.getGroups();
        if (mygroups.length == 0 || m3.getGroups().length == 0) {
            return false;
        }
        List<String> cfgMethodGroups = Arrays.asList(m3.getGroups());
        return Arrays.stream(mygroups).anyMatch(cfgMethodGroups::contains);
    }

    static void copyAttributes(ITestResult source, ITestResult target) {
        source.getAttributeNames().forEach(name -> target.setAttribute((String)name, source.getAttribute((String)name)));
    }
}

